/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.hud;

import com.google.common.base.Strings;
import elec332.core.ElecCore;
import elec332.core.api.config.IConfigurableElement;
import elec332.core.hud.position.Alignment;
import elec332.core.hud.position.HorizontalStartingPoint;
import elec332.core.hud.position.IStartingPoint;
import elec332.core.hud.position.VerticalStartingPoint;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractHud
implements IConfigurableElement {
    private String category;
    private boolean configuredOnce;
    private static final String[] a;
    private static final String[] h;
    private static final String[] v;
    private Alignment alignment = Alignment.LEFT;
    private IStartingPoint horiz = HorizontalStartingPoint.LEFT;
    private IStartingPoint ver = VerticalStartingPoint.MIDDLE;

    public AbstractHud(@Nonnull Alignment alignment, @Nonnull IStartingPoint horizontal, @Nonnull IStartingPoint vertical) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.alignment = alignment;
        this.horiz = horizontal;
        this.ver = vertical;
        this.category = "client";
    }

    public AbstractHud setConfigCategory(String s) {
        if (Strings.isNullOrEmpty((String)s)) {
            throw new IllegalArgumentException();
        }
        if (this.configuredOnce) {
            throw new IllegalStateException();
        }
        this.category = s;
        return this;
    }

    @Override
    public void reconfigure(Configuration config) {
        if (config != null) {
            if (!this.configuredOnce) {
                this.configuredOnce = true;
            }
            this.alignment = Alignment.valueOf(config.getString("alignment", this.category, this.alignment.toString(), "The alignment for this hud.", a));
            if (!(this.horiz instanceof HorizontalStartingPoint) || !(this.ver instanceof VerticalStartingPoint)) {
                this.configureCustom(config, this.horiz, this.ver);
            } else {
                this.horiz = HorizontalStartingPoint.valueOf(config.getString("horizontalPosition", this.category, this.horiz.toString(), "The horizontal position of this hud.", h));
                this.ver = VerticalStartingPoint.valueOf(config.getString("verticalPosition", this.category, this.ver.toString(), "The vertical position of this hud.", v));
            }
            this.configure(config);
        }
    }

    public String getConfigCategory() {
        return this.category;
    }

    protected void configureCustom(@Nonnull Configuration config, @Nonnull IStartingPoint horizontal, @Nonnull IStartingPoint vertical) {
        throw new UnsupportedOperationException();
    }

    protected abstract void configure(@Nonnull Configuration var1);

    @Nonnull
    protected Alignment getAlignment() {
        return this.alignment;
    }

    @Nonnull
    protected IStartingPoint getHorizontalStartingPoint() {
        return this.horiz;
    }

    @Nonnull
    protected IStartingPoint getVerticalStartingPoint() {
        return this.ver;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public final void onRenderTick(TickEvent.RenderTickEvent event) {
        EntityPlayerSP player = (EntityPlayerSP)ElecCore.proxy.getClientPlayer();
        if (player != null && Minecraft.func_71410_x().field_71415_G && this.shouldRenderHud(player, event.renderTickTime, event.phase)) {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution res = new ScaledResolution(mc);
            int hudHeight = this.getHudHeight();
            int startX = this.getHorizontalStartingPoint().getStartingPoint(mc, res, hudHeight);
            int startY = this.getVerticalStartingPoint().getStartingPoint(mc, res, hudHeight);
            this.renderHud(player, ElecCore.proxy.getClientWorld(), this.getAlignment(), startX, startY, event.renderTickTime);
        }
    }

    protected boolean shouldRenderHud(@Nonnull EntityPlayerSP player, float partialTicks, TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    public abstract int getHudHeight();

    @SideOnly(value=Side.CLIENT)
    public abstract void renderHud(@Nonnull EntityPlayerSP var1, @Nonnull World var2, @Nonnull Alignment var3, int var4, int var5, float var6);

    static {
        int i;
        a = new String[Alignment.values().length];
        for (i = 0; i < a.length; ++i) {
            AbstractHud.a[i] = Alignment.values()[i].toString();
        }
        h = new String[HorizontalStartingPoint.values().length];
        for (i = 0; i < h.length; ++i) {
            AbstractHud.h[i] = HorizontalStartingPoint.values()[i].toString();
        }
        v = new String[VerticalStartingPoint.values().length];
        for (i = 0; i < v.length; ++i) {
            AbstractHud.v[i] = VerticalStartingPoint.values()[i].toString();
        }
    }
}

