/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.client.model.template;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import elec332.core.api.client.model.template.IQuadTemplate;
import elec332.core.api.client.model.template.IQuadTemplateSidedMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MutableQuadSidedMap
implements IQuadTemplateSidedMap {
    private EnumMap<EnumFacing, List<IQuadTemplate>> quads;

    @Nonnull
    public static MutableQuadSidedMap newQuadSidedMap() {
        EnumMap param = Maps.newEnumMap(EnumFacing.class);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            param.put(facing, Lists.newArrayList());
        }
        return new MutableQuadSidedMap(param);
    }

    private MutableQuadSidedMap(EnumMap<EnumFacing, List<IQuadTemplate>> quads) {
        this.quads = quads;
    }

    @Override
    public void setQuadsForSide(EnumFacing side, @Nonnull List<IQuadTemplate> newQuads) {
        this.quads.put(side, newQuads);
    }

    @Override
    public void addQuadsForSide(EnumFacing side, List<IQuadTemplate> toAdd) {
        for (IQuadTemplate template : toAdd) {
            this.addQuadForSide(side, template);
        }
    }

    @Override
    public void addQuadForSide(EnumFacing side, IQuadTemplate toAdd) {
        this.getForSide(side).add(toAdd);
    }

    @Override
    @Nonnull
    public List<IQuadTemplate> getForSide(EnumFacing side) {
        ArrayList ret = this.quads.get(side);
        if (ret == null) {
            ret = Lists.newArrayList();
            this.quads.put(side, ret);
        }
        return ret;
    }
}

