/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.block;

import elec332.core.block.BlockMethods;
import elec332.core.block.IAbstractBlock;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractBlockFalling
extends BlockFalling
implements IAbstractBlock {
    private String unlocalizedName;

    public AbstractBlockFalling() {
        this(Material.field_151595_p);
    }

    public AbstractBlockFalling(Material material) {
        super(material);
    }

    @Nonnull
    public String func_149739_a() {
        if (this.unlocalizedName == null) {
            this.unlocalizedName = BlockMethods.createUnlocalizedName(this);
        }
        return this.unlocalizedName;
    }

    public RayTraceResult func_180636_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Vec3d start, @Nonnull Vec3d end) {
        return BlockMethods.collisionRayTrace(state, world, pos, start, end, this);
    }

    public void func_185477_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull AxisAlignedBB entityBox, @Nonnull List<AxisAlignedBB> collidingBoxes, Entity entityIn, boolean isActualState) {
        BlockMethods.addCollisionBoxToList(state, world, pos, entityBox, collidingBoxes, entityIn, isActualState, this);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, @Nonnull World world, @Nonnull BlockPos pos) {
        return BlockMethods.getSelectedBoundingBox(state, world, pos, this);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return BlockMethods.onBlockActivated(world, pos, state, player, hand, facing, hitX, hitY, hitZ, this);
    }

    public boolean removedByPlayer(@Nonnull IBlockState state, World world, @Nonnull BlockPos pos, @Nonnull EntityPlayer player, boolean willHarvest) {
        return BlockMethods.removedByPlayer(state, world, pos, player, willHarvest, this);
    }
}

