/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.api.world;

import elec332.core.api.config.IConfigurableElement;
import elec332.core.api.world.IAdvancedChunkPopulator;
import elec332.core.api.world.IFeatureGenerator;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.config.Configuration;

public class FeatureGeneratorWrapper
implements IAdvancedChunkPopulator,
IConfigurableElement {
    private final IFeatureGenerator generator;
    private final String name;
    private String genkey = "initial";

    public FeatureGeneratorWrapper(IFeatureGenerator generator) {
        this.generator = generator;
        this.name = generator.getName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getGenKey() {
        return this.genkey;
    }

    @Override
    public void populateChunk(IChunkGenerator chunkGenerator, World world, Random random, int chunkX, int chunkZ, boolean hasVillageGenerated) {
        this.generator.generateFeature(random, chunkX, chunkZ, world);
    }

    @Override
    public boolean retroGen(Random random, int chunkX, int chunkZ, World world) {
        return this.generator.generateFeature(random, chunkX, chunkZ, world);
    }

    @Override
    public void reconfigure(Configuration config) {
        if (this.generator instanceof IConfigurableElement) {
            ((IConfigurableElement)((Object)this.generator)).reconfigure(config);
        }
        this.genkey = config.getString("generationKey", this.getName(), this.genkey, "When this key differs from the key stored in the chunk data, the chunk will be retrogenned.");
    }
}

