/*
 * Decompiled with CFR 0.152.
 */
package elec332.core;

import elec332.core.api.mod.IElecCoreMod;
import elec332.core.api.module.IModuleController;
import elec332.core.api.network.ModNetworkHandler;
import elec332.core.grid.internal.GridEventInputHandler;
import elec332.core.handler.TickHandler;
import elec332.core.handler.event.PlayerEventHandler;
import elec332.core.inventory.window.WindowManager;
import elec332.core.network.IElecNetworkHandler;
import elec332.core.network.packets.PacketReRenderBlock;
import elec332.core.network.packets.PacketSyncWidget;
import elec332.core.network.packets.PacketTileDataToServer;
import elec332.core.network.packets.PacketWidgetDataToServer;
import elec332.core.proxies.CommonProxy;
import elec332.core.util.CommandHelper;
import elec332.core.util.LoadTimer;
import elec332.core.util.OredictHelper;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="eleccore", name="ElecCore", dependencies="required-after:forge@[13.19.1.2195,);after:forestry", acceptedMinecraftVersions="[1.12.2,)", version="1.9.453", useMetadata=true)
public class ElecCore
implements IModuleController,
IElecCoreMod {
    public static final String VERSION = "1.9.453";
    public static final String MODID = "eleccore";
    public static final String MODNAME = "ElecCore";
    public static final String MC_VERSIONS = "[1.12.2,)";
    public static final String FORGE_VERSION = "[13.19.1.2195,)";
    @SidedProxy(clientSide="elec332.core.proxies.ClientProxy", serverSide="elec332.core.proxies.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="eleccore")
    public static ElecCore instance;
    @ModNetworkHandler
    public static IElecNetworkHandler networkHandler;
    public static TickHandler tickHandler;
    public static Logger logger;
    private Configuration config;
    private LoadTimer loadTimer;
    public static final boolean developmentEnvironment;
    public static boolean debug;
    public static boolean removeJSONErrors;
    public static boolean suppressSpongeIssues;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = LogManager.getLogger((String)MODNAME);
        this.loadTimer = new LoadTimer(logger, MODNAME);
        this.loadTimer.startPhase((FMLStateEvent)event);
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.config.load();
        debug = this.config.getBoolean("debug", "general", false, "Set to true to print debug info to the log.");
        removeJSONErrors = this.config.getBoolean("removeJsonExceptions", "client", true, "Set to true to remove all the Json model errors from the log.") && !developmentEnvironment;
        suppressSpongeIssues = this.config.getBoolean("supressSpongeIssues", "general", false, "Set to true to prevent multiblock crashes when Sponge is installed. WARNING: Unsupported, this may cause unexpected behaviour, use with caution!");
        tickHandler = new TickHandler();
        proxy.preInitRendering();
        this.loadTimer.endPhase((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.loadTimer.startPhase((FMLStateEvent)event);
        if (this.config.hasChanged()) {
            this.config.save();
        }
        networkHandler.registerPacket(WindowManager.INSTANCE);
        networkHandler.registerClientPacket(PacketSyncWidget.class);
        networkHandler.registerServerPacket(PacketTileDataToServer.class);
        networkHandler.registerServerPacket(PacketWidgetDataToServer.class);
        networkHandler.registerClientPacket(PacketReRenderBlock.class);
        OredictHelper.initLists();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        this.loadTimer.endPhase((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.loadTimer.startPhase((FMLStateEvent)event);
        OredictHelper.initLists();
        proxy.postInitRendering();
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEventHandler());
        this.loadTimer.endPhase((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void loadComplete(FMLLoadCompleteEvent event) {
        this.loadTimer.startPhase((FMLStateEvent)event);
        OredictHelper.initLists();
        this.loadTimer.endPhase((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        GridEventInputHandler.INSTANCE.reloadHandlers();
    }

    @Mod.EventHandler
    public void onServerStarting(FMLServerStartingEvent event) {
        CommandHelper.registerCommands(event);
    }

    @Override
    public boolean isModuleEnabled(String moduleName) {
        return true;
    }

    static {
        debug = false;
        removeJSONErrors = true;
        suppressSpongeIssues = false;
        developmentEnvironment = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }
}

