/*
 * Decompiled with CFR 0.152.
 */
package com.warmthdawn.justenoughdrags.jei;

import com.warmthdawn.justenoughdrags.network.NetworkHandler;
import com.warmthdawn.justenoughdrags.network.PacketSetContainerSlot;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GenericGhostHandler<T extends GuiContainer>
implements IGhostIngredientHandler<T> {
    protected final Class applySlot;
    protected Container lastContainer;

    public <I extends Slot> GenericGhostHandler(Class<I> applySlot) {
        this.applySlot = applySlot;
    }

    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(T gui, I ingredient, boolean doStart) {
        ArrayList<IGhostIngredientHandler.Target<I>> targets = new ArrayList<IGhostIngredientHandler.Target<I>>();
        if (ingredient instanceof ItemStack) {
            ItemStack stack = ((ItemStack)ingredient).func_77946_l();
            for (Slot slot : ((GuiContainer)gui).field_147002_h.field_75151_b) {
                if (!this.isSlotValid(slot, stack, doStart)) continue;
                targets.add(this.createTarget(slot, gui));
            }
        }
        this.lastContainer = ((GuiContainer)gui).field_147002_h;
        return targets;
    }

    public <I> IGhostIngredientHandler.Target<I> createTarget(Slot slot, T gui) {
        return new GhostTarget(slot, gui.getGuiLeft(), gui.getGuiTop());
    }

    public boolean isSlotValid(Slot slot, ItemStack stack, boolean doStart) {
        return this.applySlot.isAssignableFrom(slot.getClass()) && slot.func_75214_a(stack);
    }

    public void onComplete() {
        if (this.lastContainer != null) {
            this.lastContainer.func_75142_b();
        }
    }

    protected static class GhostTarget<I>
    implements IGhostIngredientHandler.Target<I> {
        protected final Rectangle rectangle;
        protected final Slot slot;

        public GhostTarget(Slot slot, int xoff, int yoff) {
            this.rectangle = new Rectangle(slot.field_75223_e + xoff, slot.field_75221_f + yoff, 16, 16);
            this.slot = slot;
        }

        public Rectangle getArea() {
            return this.rectangle;
        }

        public void accept(I ingredient) {
            if (ingredient instanceof ItemStack) {
                ItemStack stack = ((ItemStack)ingredient).func_77946_l();
                this.slot.func_75215_d(stack);
                this.slot.func_75218_e();
                NetworkHandler.INSTANCE.sendToServer((IMessage)new PacketSetContainerSlot(this.slot.field_75222_d, stack));
            }
        }
    }
}

