/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigTwilightForest;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.integrations.jer.conditionals.JEMLightLevel;
import com.invadermonky.justenoughmagiculture.util.BiomeHelper;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import com.invadermonky.justenoughmagiculture.util.StringHelper;
import jeresources.api.conditionals.LightLevel;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import twilightforest.TwilightForestMod;
import twilightforest.biomes.RegistryBiomeEvent;
import twilightforest.entity.EntityTFArmoredGiant;
import twilightforest.entity.EntityTFBlockGoblin;
import twilightforest.entity.EntityTFDeathTome;
import twilightforest.entity.EntityTFFireBeetle;
import twilightforest.entity.EntityTFGiantMiner;
import twilightforest.entity.EntityTFGoblinKnightUpper;
import twilightforest.entity.EntityTFHedgeSpider;
import twilightforest.entity.EntityTFHelmetCrab;
import twilightforest.entity.EntityTFHostileWolf;
import twilightforest.entity.EntityTFIceExploder;
import twilightforest.entity.EntityTFIceShooter;
import twilightforest.entity.EntityTFKingSpider;
import twilightforest.entity.EntityTFKobold;
import twilightforest.entity.EntityTFMazeSlime;
import twilightforest.entity.EntityTFMiniGhast;
import twilightforest.entity.EntityTFMinotaur;
import twilightforest.entity.EntityTFMistWolf;
import twilightforest.entity.EntityTFMosquitoSwarm;
import twilightforest.entity.EntityTFPinchBeetle;
import twilightforest.entity.EntityTFRedcap;
import twilightforest.entity.EntityTFRedcapSapper;
import twilightforest.entity.EntityTFSkeletonDruid;
import twilightforest.entity.EntityTFSlimeBeetle;
import twilightforest.entity.EntityTFSnowGuardian;
import twilightforest.entity.EntityTFSwarmSpider;
import twilightforest.entity.EntityTFTowerBroodling;
import twilightforest.entity.EntityTFTowerGhast;
import twilightforest.entity.EntityTFTowerGolem;
import twilightforest.entity.EntityTFTowerTermite;
import twilightforest.entity.EntityTFTroll;
import twilightforest.entity.EntityTFWinterWolf;
import twilightforest.entity.EntityTFWraith;
import twilightforest.entity.EntityTFYeti;
import twilightforest.entity.boss.EntityTFHydra;
import twilightforest.entity.boss.EntityTFHydraHead;
import twilightforest.entity.boss.EntityTFKnightPhantom;
import twilightforest.entity.boss.EntityTFLich;
import twilightforest.entity.boss.EntityTFMinoshroom;
import twilightforest.entity.boss.EntityTFNaga;
import twilightforest.entity.boss.EntityTFUrGhast;
import twilightforest.entity.boss.EntityTFYetiAlpha;
import twilightforest.entity.passive.EntityTFBighorn;
import twilightforest.entity.passive.EntityTFBoar;
import twilightforest.entity.passive.EntityTFBunny;
import twilightforest.entity.passive.EntityTFDeer;
import twilightforest.entity.passive.EntityTFMobileFirefly;
import twilightforest.entity.passive.EntityTFPenguin;
import twilightforest.entity.passive.EntityTFRaven;
import twilightforest.entity.passive.EntityTFSquirrel;
import twilightforest.entity.passive.EntityTFTinyBird;
import twilightforest.item.TFItems;

public class JERTwilightForest
extends JERBase
implements IJERIntegration {
    private final JEMConfigTwilightForest.JER jerConfig;
    private final String[] tfBiomeType;

    public JERTwilightForest(boolean enableJERDungeons, boolean enableJEREntities) {
        this.jerConfig = JEMConfig.TWILIGHT_FOREST.JUST_ENOUGH_RESOURCES;
        this.tfBiomeType = BiomeHelper.getTypeNamesForTypes(RegistryBiomeEvent.TWILIGHT);
        if (enableJERDungeons) {
            this.registerModDungeons();
        }
        if (enableJEREntities) {
            this.registerModEntities();
        }
    }

    @Override
    public void registerModDungeons() {
        this.registerTFDungeonLoot("aurora_cache");
        this.registerTFDungeonLoot("aurora_room");
        this.registerTFDungeonLoot("basement");
        this.registerTFDungeonLoot("darktower_cache");
        this.registerTFDungeonLoot("darktower_key");
        this.registerTFDungeonLoot("graveyard");
        this.registerTFDungeonLoot("hedge_maze");
        this.registerTFDungeonLoot("hill_1");
        this.registerTFDungeonLoot("hill_2");
        this.registerTFDungeonLoot("hill_3");
        this.registerTFDungeonLoot("labyrinth_dead_end");
        this.registerTFDungeonLoot("labyrinth_room");
        this.registerTFDungeonLoot("labyrinth_vault");
        this.registerTFDungeonLoot("stronghold_cache");
        this.registerTFDungeonLoot("stronghold_room");
        this.registerTFDungeonLoot("tower_library");
        this.registerTFDungeonLoot("tower_room");
        this.registerTFDungeonLoot("tree_cache");
        this.registerTFDungeonLoot("troll_garden");
        this.registerTFDungeonLoot("troll_vault");
    }

    @Override
    public void registerModEntities() {
        this.registerBosses();
        this.registerMobs();
        this.registerPassive();
    }

    private void registerBosses() {
        if (this.jerConfig.enableHydra) {
            EntityTFHydra hydra = new EntityTFHydra(this.world);
            EntityTFHydraHead hydraHead = new EntityTFHydraHead(this.world);
            this.registerMob((EntityLivingBase)hydraHead, LightLevel.hostile, this.tfBiomeType, hydra.func_184647_J());
            this.registerRenderHook(hydraHead.getClass(), (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)0.6, (double)0.6, (double)0.6);
                GlStateManager.func_179137_b((double)-0.05, (double)-1.0, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.enableKnightPhantom) {
            EntityTFKnightPhantom knightPhantom = new EntityTFKnightPhantom(this.world);
            knightPhantom.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(TFItems.knightmetal_sword));
            knightPhantom.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(TFItems.phantom_chestplate));
            knightPhantom.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(TFItems.phantom_helmet));
            this.registerMob((EntityLivingBase)knightPhantom, LightLevel.hostile, this.tfBiomeType, new JERDungeonStrings((String)"stronghold_boss").lootTable);
            this.adjustHumanoidRenderHook(knightPhantom.getClass());
        }
        if (this.jerConfig.enableTwilightLich) {
            EntityTFLich lich = new EntityTFLich(this.world);
            this.registerMob((EntityLivingBase)lich, LightLevel.hostile, this.tfBiomeType, lich.func_184647_J());
            this.adjustLargeHumanoidRenderHook(lich.getClass());
        }
        if (this.jerConfig.enableMinoshroom) {
            EntityTFMinoshroom minoshroom = new EntityTFMinoshroom(this.world);
            this.registerMob((EntityLivingBase)minoshroom, LightLevel.hostile, this.tfBiomeType, minoshroom.func_184647_J());
        }
        if (this.jerConfig.enableNaga) {
            EntityTFNaga naga = new EntityTFNaga(this.world);
            this.registerMob((EntityLivingBase)naga, LightLevel.any, this.tfBiomeType, naga.func_184647_J());
            this.registerRenderHook(naga.getClass(), (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)-0.05, (double)-0.8, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.enableQuestingRam) {
            this.registerDungeonLoot(ModIds.TWILIGHT_FOREST.MOD_ID + ":entities/quest_ram_rewards", "dungeon.jem:" + ModIds.TWILIGHT_FOREST.MOD_ID + ".quest_ram_rewards", new ResourceLocation(ModIds.TWILIGHT_FOREST.MOD_ID, "entities/questing_ram_rewards"));
        }
        if (this.jerConfig.enableUrGhast) {
            EntityTFUrGhast urGhast = new EntityTFUrGhast(this.world);
            this.registerMob((EntityLivingBase)urGhast, LightLevel.hostile, this.tfBiomeType, new JERDungeonStrings((String)"darktower_boss").lootTable);
            this.registerRenderHook(urGhast.getClass(), (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)0.25, (double)0.25, (double)0.25);
                GlStateManager.func_179137_b((double)-0.25, (double)-1.75, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.enableYetiAlpha) {
            EntityTFYetiAlpha yetiAlpha = new EntityTFYetiAlpha(this.world);
            this.registerMob((EntityLivingBase)yetiAlpha, LightLevel.hostile, this.tfBiomeType, yetiAlpha.func_184647_J());
            this.adjustHugeHumanoidRenderHook(yetiAlpha.getClass());
        }
    }

    private void registerMobs() {
        if (this.jerConfig.enableArmoredGiant) {
            EntityTFArmoredGiant armoredGiant = new EntityTFArmoredGiant(this.world);
            armoredGiant.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151052_q));
            armoredGiant.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151028_Y));
            armoredGiant.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151030_Z));
            armoredGiant.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151165_aa));
            armoredGiant.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151167_ab));
            this.registerMob((EntityLivingBase)armoredGiant, LightLevel.hostile, this.tfBiomeType, armoredGiant.func_184647_J());
        }
        if (this.jerConfig.enableBlockGoblin) {
            EntityTFBlockGoblin blockGoblin = new EntityTFBlockGoblin(this.world);
            this.registerMob((EntityLivingBase)blockGoblin, LightLevel.hostile, this.tfBiomeType, blockGoblin.func_184647_J());
            this.adjustHumanoidRenderHook(blockGoblin.getClass());
        }
        if (this.jerConfig.enableDeathTome) {
            EntityTFDeathTome deathTome = new EntityTFDeathTome(this.world);
            this.registerMob((EntityLivingBase)deathTome, LightLevel.hostile, this.tfBiomeType, deathTome.func_184647_J());
            this.adjustHumanoidRenderHook(deathTome.getClass());
        }
        if (this.jerConfig.enableFireBeetle) {
            EntityTFFireBeetle fireBeetle = new EntityTFFireBeetle(this.world);
            this.registerMob((EntityLivingBase)fireBeetle, LightLevel.hostile, this.tfBiomeType, fireBeetle.func_184647_J());
        }
        if (this.jerConfig.enableGiantMiner) {
            EntityTFGiantMiner giantMiner = new EntityTFGiantMiner(this.world);
            giantMiner.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151050_s));
            this.registerMob((EntityLivingBase)giantMiner, LightLevel.hostile, this.tfBiomeType, giantMiner.func_184647_J());
            this.adjustHugeHumanoidRenderHook(giantMiner.getClass());
        }
        if (this.jerConfig.enableGoblinKnight) {
            EntityTFGoblinKnightUpper goblinKnightUpper = new EntityTFGoblinKnightUpper(this.world);
            this.registerMob((EntityLivingBase)goblinKnightUpper, LightLevel.hostile, this.tfBiomeType, goblinKnightUpper.func_184647_J());
        }
        if (this.jerConfig.enableHedgeSpider) {
            EntityTFHedgeSpider hedgeSpider = new EntityTFHedgeSpider(this.world);
            this.registerMob((EntityLivingBase)hedgeSpider, LightLevel.hostile, this.tfBiomeType, TwilightForestMod.prefix((String)"entities/hedge_spider"));
        }
        if (this.jerConfig.enableHelmetCrab) {
            EntityTFHelmetCrab helmetCrab = new EntityTFHelmetCrab(this.world);
            this.registerMob((EntityLivingBase)helmetCrab, LightLevel.hostile, this.tfBiomeType, helmetCrab.func_184647_J());
        }
        if (this.jerConfig.enableHostileWolf) {
            EntityTFHostileWolf hostileWolf = new EntityTFHostileWolf(this.world);
            this.registerMob((EntityLivingBase)hostileWolf, LightLevel.hostile, this.tfBiomeType, TwilightForestMod.prefix((String)"entities/hostile_wolf"));
        }
        if (this.jerConfig.enableUnstableIceCore) {
            EntityTFIceExploder iceExploder = new EntityTFIceExploder(this.world);
            this.registerMob((EntityLivingBase)iceExploder, LightLevel.hostile, this.tfBiomeType, iceExploder.func_184647_J());
            this.registerRenderHook(iceExploder.getClass(), (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)-0.1, (double)-0.5, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.enableStableIceCore) {
            EntityTFIceShooter iceShooter = new EntityTFIceShooter(this.world);
            this.registerMob((EntityLivingBase)iceShooter, LightLevel.hostile, this.tfBiomeType, iceShooter.func_184647_J());
            this.registerRenderHook(iceShooter.getClass(), (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)-0.1, (double)-0.5, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.enableKingSpider) {
            EntityTFKingSpider kingSpider = new EntityTFKingSpider(this.world);
            this.registerMob((EntityLivingBase)kingSpider, LightLevel.hostile, this.tfBiomeType, TwilightForestMod.prefix((String)"entities/king_spider"));
            this.registerRenderHook(kingSpider.getClass(), (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
                GlStateManager.func_179137_b((double)0.0, (double)-0.5, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.enableKobold) {
            EntityTFKobold kobold = new EntityTFKobold(this.world);
            this.registerMob((EntityLivingBase)kobold, LightLevel.hostile, this.tfBiomeType, kobold.func_184647_J());
            this.adjustHumanoidRenderHook(kobold.getClass());
        }
        if (this.jerConfig.enableMazeSlime) {
            EntityTFMazeSlime mazeSlime = new EntityTFMazeSlime(this.world);
            this.registerMob((EntityLivingBase)mazeSlime, LightLevel.hostile, 1, 3, this.tfBiomeType, mazeSlime.func_184647_J());
        }
        if (this.jerConfig.enableCarminiteGhasting) {
            EntityTFMiniGhast miniGhast = new EntityTFMiniGhast(this.world);
            this.registerMob((EntityLivingBase)miniGhast, LightLevel.hostile, this.tfBiomeType, miniGhast.func_184647_J());
            this.registerRenderHook(miniGhast.getClass(), (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)0.0, (double)2.25, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.enableMInotaur) {
            EntityTFMinotaur minotaur = new EntityTFMinotaur(this.world);
            minotaur.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151006_E));
            this.registerMob((EntityLivingBase)minotaur, LightLevel.hostile, this.tfBiomeType, minotaur.func_184647_J());
            this.adjustHumanoidRenderHook(minotaur.getClass());
        }
        if (this.jerConfig.enableMistWolf) {
            EntityTFMistWolf mistWolf = new EntityTFMistWolf(this.world);
            this.registerMob((EntityLivingBase)mistWolf, LightLevel.hostile, this.tfBiomeType, TwilightForestMod.prefix((String)"entities/mist_wolf"));
            this.registerRenderHook(mistWolf.getClass(), (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)0.7, (double)0.7, (double)0.7);
                return renderInfo;
            });
        }
        if (this.jerConfig.enableMosquitoSwarm) {
            EntityTFMosquitoSwarm mosquitoSwarm = new EntityTFMosquitoSwarm(this.world);
            this.registerMob((EntityLivingBase)mosquitoSwarm, LightLevel.hostile, this.tfBiomeType, TwilightForestMod.prefix((String)"entities/mosquito_swarm"));
            this.registerRenderHook(mosquitoSwarm.getClass(), (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
                GlStateManager.func_179137_b((double)-0.05, (double)-0.8, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.enablePinchBeetle) {
            EntityTFPinchBeetle pinchBeetle = new EntityTFPinchBeetle(this.world);
            this.registerMob((EntityLivingBase)pinchBeetle, LightLevel.hostile, this.tfBiomeType, TwilightForestMod.prefix((String)"entities/pinch_beetle"));
        }
        if (this.jerConfig.enableRedcapGoblin) {
            EntityTFRedcap redcap = new EntityTFRedcap(this.world);
            this.registerMob((EntityLivingBase)redcap, LightLevel.hostile, this.tfBiomeType, redcap.func_184647_J());
            this.adjustHumanoidRenderHook(redcap.getClass());
        }
        if (this.jerConfig.enableRedcapSapper) {
            EntityTFRedcapSapper redcapSapper = new EntityTFRedcapSapper(this.world);
            this.registerMob((EntityLivingBase)redcapSapper, LightLevel.hostile, this.tfBiomeType, redcapSapper.func_184647_J());
        }
        if (this.jerConfig.enableSkeletonDruid) {
            EntityTFSkeletonDruid skeletonDruid = new EntityTFSkeletonDruid(this.world);
            this.registerMob((EntityLivingBase)skeletonDruid, LightLevel.hostile, this.tfBiomeType, skeletonDruid.func_184647_J());
        }
        if (this.jerConfig.enableSlimeBeetle) {
            EntityTFSlimeBeetle slimeBeetle = new EntityTFSlimeBeetle(this.world);
            this.registerMob((EntityLivingBase)slimeBeetle, LightLevel.hostile, this.tfBiomeType, slimeBeetle.func_184647_J());
        }
        if (this.jerConfig.enableSnowGuardian) {
            EntityTFSnowGuardian snowGuardian = new EntityTFSnowGuardian(this.world);
            snowGuardian.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(TFItems.ironwood_sword));
            snowGuardian.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(TFItems.ironwood_helmet));
            snowGuardian.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(TFItems.ironwood_chestplate));
            this.registerMob((EntityLivingBase)snowGuardian, LightLevel.hostile, this.tfBiomeType, snowGuardian.func_184647_J());
            this.adjustHumanoidRenderHook(snowGuardian.getClass());
        }
        if (this.jerConfig.enableSwarmSpider) {
            EntityTFSwarmSpider swarmSpider = new EntityTFSwarmSpider(this.world);
            this.registerMob((EntityLivingBase)swarmSpider, LightLevel.hostile, this.tfBiomeType, TwilightForestMod.prefix((String)"entities/swarm_spider"));
        }
        if (this.jerConfig.enableCarminiteBroodling) {
            EntityTFTowerBroodling towerBroodling = new EntityTFTowerBroodling(this.world);
            this.registerMob((EntityLivingBase)towerBroodling, LightLevel.hostile, this.tfBiomeType, TwilightForestMod.prefix((String)"entities/tower_broodling"));
        }
        if (this.jerConfig.enableCarminiteGhast) {
            EntityTFTowerGhast towerGhast = new EntityTFTowerGhast(this.world);
            this.registerMob((EntityLivingBase)towerGhast, LightLevel.hostile, this.tfBiomeType, TwilightForestMod.prefix((String)"entities/tower_ghast"));
            this.registerRenderHook(towerGhast.getClass(), (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)0.0, (double)-2.75, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.enableCarminiteGolem) {
            EntityTFTowerGolem towerGolem = new EntityTFTowerGolem(this.world);
            this.registerMob((EntityLivingBase)towerGolem, LightLevel.hostile, this.tfBiomeType, towerGolem.func_184647_J());
            this.adjustLargeHumanoidRenderHook(towerGolem.getClass());
        }
        if (this.jerConfig.enableTowerwoodBorer) {
            EntityTFTowerTermite towerTermite = new EntityTFTowerTermite(this.world);
            this.registerMob((EntityLivingBase)towerTermite, LightLevel.hostile, this.tfBiomeType, towerTermite.func_184647_J());
        }
        if (this.jerConfig.enableCaveTroll) {
            EntityTFTroll troll = new EntityTFTroll(this.world);
            this.registerMob((EntityLivingBase)troll, LightLevel.hostile, this.tfBiomeType, troll.func_184647_J());
            this.adjustLargeHumanoidRenderHook(troll.getClass());
        }
        if (this.jerConfig.enableWinterWolf) {
            EntityTFWinterWolf winterWolf = new EntityTFWinterWolf(this.world);
            this.registerMob((EntityLivingBase)winterWolf, LightLevel.hostile, this.tfBiomeType, winterWolf.func_184647_J());
            this.registerRenderHook(winterWolf.getClass(), (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)0.7, (double)0.7, (double)0.7);
                return renderInfo;
            });
        }
        if (this.jerConfig.enableTwilightWraith) {
            EntityTFWraith wraith = new EntityTFWraith(this.world);
            this.registerMob((EntityLivingBase)wraith, LightLevel.hostile, this.tfBiomeType, wraith.func_184647_J());
            this.adjustHumanoidRenderHook(wraith.getClass());
        }
        if (this.jerConfig.enableYeti) {
            EntityTFYeti yeti = new EntityTFYeti(this.world);
            this.registerMob((EntityLivingBase)yeti, LightLevel.any, this.tfBiomeType, yeti.func_184647_J());
            this.adjustLargeHumanoidRenderHook(yeti.getClass());
        }
    }

    private void registerPassive() {
        if (this.jerConfig.enableBighornSheep) {
            for (EnumDyeColor color : EnumDyeColor.values()) {
                EntityTFBighorn bighorn = new EntityTFBighorn(this.world);
                bighorn.func_175512_b(color);
                ResourceLocation bighornTable = new ResourceLocation(ModIds.TWILIGHT_FOREST.MOD_ID, "entities/bighorn_sheep/" + color.func_176610_l());
                this.registerMob((EntityLivingBase)bighorn, JEMLightLevel.animal, this.tfBiomeType, bighornTable);
            }
        }
        if (this.jerConfig.enableWildBoar) {
            EntityTFBoar boar = new EntityTFBoar(this.world);
            this.registerMob((EntityLivingBase)boar, JEMLightLevel.animal, this.tfBiomeType, boar.func_184647_J());
        }
        if (this.jerConfig.enableDwarfRabbit) {
            EntityTFBunny bunny = new EntityTFBunny(this.world);
            this.registerMob((EntityLivingBase)bunny, JEMLightLevel.animal, this.tfBiomeType, bunny.func_184647_J());
            this.registerRenderHook(bunny.getClass(), (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)0.0, (double)-0.25, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.enableWildDeer) {
            EntityTFDeer deer = new EntityTFDeer(this.world);
            this.registerMob((EntityLivingBase)deer, JEMLightLevel.animal, this.tfBiomeType, deer.func_184647_J());
        }
        if (this.jerConfig.enableFirefly) {
            EntityTFMobileFirefly firefly = new EntityTFMobileFirefly(this.world);
            this.registerMob((EntityLivingBase)firefly, JEMLightLevel.animal, this.tfBiomeType, new ResourceLocation(ModIds.TWILIGHT_FOREST.MOD_ID, "entities/mobile_firefly"));
        }
        if (this.jerConfig.enablePenguin) {
            EntityTFPenguin penguin = new EntityTFPenguin(this.world);
            this.registerMob((EntityLivingBase)penguin, JEMLightLevel.animal, this.tfBiomeType, penguin.func_184647_J());
        }
        if (this.jerConfig.enableForestRaven) {
            EntityTFRaven raven = new EntityTFRaven(this.world);
            this.registerMob((EntityLivingBase)raven, JEMLightLevel.animal, this.tfBiomeType, raven.func_184647_J());
        }
        if (this.jerConfig.enableForestSquirrel) {
            EntityTFSquirrel squirrel = new EntityTFSquirrel(this.world);
            this.registerMob((EntityLivingBase)squirrel, JEMLightLevel.animal, this.tfBiomeType, squirrel.func_184647_J());
            this.registerRenderHook(squirrel.getClass(), (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)0.0, (double)-0.25, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.enableTinyBird) {
            EntityTFTinyBird tinyBird = new EntityTFTinyBird(this.world);
            this.registerMob((EntityLivingBase)tinyBird, JEMLightLevel.animal, this.tfBiomeType, tinyBird.func_184647_J());
        }
    }

    private void adjustHumanoidRenderHook(Class<? extends EntityLiving> clazz) {
        this.registerRenderHook(clazz, (renderInfo, e) -> {
            GlStateManager.func_179137_b((double)-0.05, (double)-0.5, (double)0.0);
            return renderInfo;
        });
    }

    private void adjustLargeHumanoidRenderHook(Class<? extends EntityLiving> clazz) {
        this.registerRenderHook(clazz, (renderInfo, e) -> {
            GlStateManager.func_179137_b((double)-0.05, (double)-0.6, (double)0.0);
            return renderInfo;
        });
    }

    private void adjustHugeHumanoidRenderHook(Class<? extends EntityLiving> clazz) {
        this.registerRenderHook(clazz, (renderInfo, e) -> {
            GlStateManager.func_179137_b((double)-0.1, (double)-1.6, (double)0.0);
            return renderInfo;
        });
    }

    private void registerTFDungeonLoot(String name) {
        JERDungeonStrings dungeon = new JERDungeonStrings(name);
        this.registerDungeonLoot(dungeon.category, dungeon.unlocName, dungeon.lootTable);
    }

    private static class JERDungeonStrings {
        public final String category;
        public final String unlocName;
        public final ResourceLocation lootTable;

        public JERDungeonStrings(String dungeon) {
            this.category = String.format("%s:structures/%s", ModIds.TWILIGHT_FOREST.MOD_ID, dungeon);
            this.unlocName = StringHelper.getDungeonTranslationKey(ModIds.TWILIGHT_FOREST.MOD_ID, dungeon);
            this.lootTable = new ResourceLocation(String.format("%s/%s", this.category, dungeon));
        }
    }
}

