/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigThaumicAugmentation;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.lootbag.LootBagEntry;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.registry.LootBagRegistry;
import com.invadermonky.justenoughmagiculture.util.BiomeHelper;
import jeresources.api.conditionals.LightLevel;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import thecodex6824.thaumicaugmentation.api.TABlocks;
import thecodex6824.thaumicaugmentation.api.TALootTables;
import thecodex6824.thaumicaugmentation.api.world.TABiomes;
import thecodex6824.thaumicaugmentation.common.entity.EntityAutocaster;
import thecodex6824.thaumicaugmentation.common.entity.EntityAutocasterEldritch;
import thecodex6824.thaumicaugmentation.common.entity.EntityPrimalWisp;
import thecodex6824.thaumicaugmentation.common.entity.EntityTAEldritchGolem;
import thecodex6824.thaumicaugmentation.common.entity.EntityTAEldritchGuardian;
import thecodex6824.thaumicaugmentation.common.entity.EntityTAEldritchWarden;

public class JERThaumicAugmentation
extends JERBase
implements IJERIntegration {
    private static JERThaumicAugmentation instance;
    private static final JEMConfigThaumicAugmentation.JER jerConfig;

    public JERThaumicAugmentation(boolean enableJERMobs) {
        if (enableJERMobs) {
            this.registerModEntities();
        }
    }

    private JERThaumicAugmentation() {
    }

    public static JERThaumicAugmentation getInstance() {
        return instance != null ? instance : (instance = new JERThaumicAugmentation());
    }

    public void registerLootBagEntries() {
        if (JEMConfig.THAUMIC_AUGMENTATION.JUST_ENOUGH_ITEMS.enableJEILootBags) {
            LootBagRegistry registry = LootBagRegistry.getInstance();
            registry.registerLootBag(new LootBagEntry(new ItemStack(TABlocks.URN, 1, 0), this.manager.func_186521_a(TALootTables.LOOT_COMMON)));
            registry.registerLootBag(new LootBagEntry(new ItemStack(TABlocks.URN, 1, 1), this.manager.func_186521_a(TALootTables.LOOT_UNCOMMON)));
            registry.registerLootBag(new LootBagEntry(new ItemStack(TABlocks.URN, 1, 2), this.manager.func_186521_a(TALootTables.LOOT_RARE)));
        }
    }

    @Override
    public void registerModEntities() {
        if (JERThaumicAugmentation.jerConfig.enableAutocaster) {
            this.registerMob((EntityLivingBase)new EntityAutocaster(this.world), LightLevel.any, TALootTables.AUTOCASTER);
        }
        if (JERThaumicAugmentation.jerConfig.enableEldritchAutocaster) {
            this.registerMob((EntityLivingBase)new EntityAutocasterEldritch(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(TABiomes.EMPTINESS), TALootTables.AUTOCASTER_ELDRITCH);
        }
        if (JERThaumicAugmentation.jerConfig.enableEldritchGolem) {
            this.registerMob((EntityLivingBase)new EntityTAEldritchGolem(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(TABiomes.EMPTINESS), TALootTables.ELDRITCH_GOLEM);
            this.registerRenderHook(EntityTAEldritchGolem.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
                GlStateManager.func_179137_b((double)-0.05, (double)-0.4, (double)0.0);
                return renderInfo;
            });
        }
        if (JERThaumicAugmentation.jerConfig.enableEldritchGuardian) {
            this.registerMob((EntityLivingBase)new EntityTAEldritchGuardian(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(TABiomes.EMPTINESS), TALootTables.ELDRITCH_GUARDIAN);
        }
        if (JERThaumicAugmentation.jerConfig.enableEldritchWarden) {
            this.registerMob((EntityLivingBase)new EntityTAEldritchWarden(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(TABiomes.EMPTINESS), TALootTables.ELDRITCH_WARDEN);
        }
        if (JERThaumicAugmentation.jerConfig.enablePrimalWisp) {
            this.registerMob((EntityLivingBase)new EntityPrimalWisp(this.world), LightLevel.any, TALootTables.PRIMAL_WISP);
        }
    }

    static {
        jerConfig = JEMConfig.THAUMIC_AUGMENTATION.JUST_ENOUGH_RESOURCES;
    }
}

