/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.google.common.collect.ImmutableSet;
import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigQuark;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.jer.villager.BasicTrade;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.jer.villager.CustomVillagerEntry;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.registry.CustomVillagerRegistry;
import com.invadermonky.justenoughmagiculture.util.BiomeHelper;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import com.invadermonky.justenoughmagiculture.util.StringHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import jeresources.api.conditionals.Conditional;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.LootDrop;
import jeresources.entry.MobEntry;
import jeresources.registry.MobRegistry;
import jeresources.util.LootTableHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.init.Biomes;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;
import vazkii.quark.base.module.Feature;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.decoration.feature.TallowAndCandles;
import vazkii.quark.misc.feature.BlackAsh;
import vazkii.quark.vanity.feature.WitchHat;
import vazkii.quark.world.entity.EntityArchaeologist;
import vazkii.quark.world.entity.EntityAshen;
import vazkii.quark.world.entity.EntityCrab;
import vazkii.quark.world.entity.EntityDweller;
import vazkii.quark.world.entity.EntityFoxhound;
import vazkii.quark.world.entity.EntityFrog;
import vazkii.quark.world.entity.EntityPirate;
import vazkii.quark.world.entity.EntityStoneling;
import vazkii.quark.world.entity.EntityWraith;
import vazkii.quark.world.feature.Archaeologist;
import vazkii.quark.world.feature.BuriedTreasure;
import vazkii.quark.world.feature.Crabs;
import vazkii.quark.world.feature.DepthMobs;
import vazkii.quark.world.feature.Foxhounds;
import vazkii.quark.world.feature.Frogs;
import vazkii.quark.world.feature.PirateShips;
import vazkii.quark.world.feature.Stonelings;
import vazkii.quark.world.feature.Wraiths;

public class JERQuark
extends JERBase
implements IJERIntegration {
    private static final JEMConfigQuark.JER jerConfig = JEMConfigQuark.JUST_ENOUGH_RESOURCES;
    private static JERQuark instance;

    private JERQuark() {
    }

    public JERQuark(boolean enableJERDungeons, boolean enableJERMobs, boolean enableJERVillagers) {
        if (enableJERDungeons) {
            this.registerModDungeons();
        }
        if (enableJERMobs) {
            this.registerModEntities();
        }
        if (enableJERVillagers) {
            this.registerModVillagers();
        }
        JERQuark.getInstance();
    }

    public static JERQuark getInstance() {
        return instance == null ? (instance = new JERQuark()) : instance;
    }

    @Override
    public void registerModDungeons() {
        if (this.isFeatureEnabled(Archaeologist.class)) {
            this.registerDungeonLoot("archaeologist");
        }
        if (this.isFeatureEnabled(BuriedTreasure.class)) {
            this.registerDungeonLoot("quark:buried_treasure", "dungeon.jem:quark.buried_treasure", LootTableList.field_186422_d);
        }
        if (this.isFeatureEnabled(PirateShips.class)) {
            this.registerDungeonLoot("pirate_chest");
        }
    }

    @Override
    public void registerModEntities() {
        if (this.isFeatureEnabled(Archaeologist.class) && Archaeologist.enableHat && JERQuark.jerConfig.JER_MOBS.enableArchaeologist) {
            EntityArchaeologist archaeologist = new EntityArchaeologist(this.world);
            this.registerMob((EntityLivingBase)archaeologist, LightLevel.any, new LootDrop(Archaeologist.archaeologist_hat, 0, 1, 0.025f, new Conditional[]{Conditional.affectedByLooting}));
            this.registerRenderHook(archaeologist.getClass(), (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)-0.05, (double)-0.45, (double)0.0);
                return renderInfo;
            });
        }
        if (this.isFeatureEnabled(Crabs.class) && JERQuark.jerConfig.JER_MOBS.enableCrab) {
            this.registerMob((EntityLivingBase)new EntityCrab(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(BiomeDictionary.Type.BEACH.getName()), EntityCrab.CRAB_LOOT_TABLE);
        }
        if (this.isFeatureEnabled(DepthMobs.class)) {
            if (DepthMobs.enableAshen && JERQuark.jerConfig.JER_MOBS.enableAshen) {
                EntityAshen ashen = new EntityAshen(this.world);
                ItemStack stack = new ItemStack(Items.field_185167_i);
                PotionUtils.func_185184_a((ItemStack)stack, (Collection)ImmutableSet.of((Object)new PotionEffect(MobEffects.field_76440_q, 50, 0)));
                ashen.func_184611_a(EnumHand.OFF_HAND, stack);
                this.registerMob((EntityLivingBase)ashen, LightLevel.hostile, LootTableList.field_186385_aj);
            }
            if (DepthMobs.enableDweller && JERQuark.jerConfig.JER_MOBS.enableDweller) {
                this.registerMob((EntityLivingBase)new EntityDweller(this.world), LightLevel.hostile, LootTableList.field_186383_ah);
            }
        }
        if (this.isFeatureEnabled(Foxhounds.class) && JERQuark.jerConfig.JER_MOBS.enableFoxhound) {
            this.registerMob((EntityLivingBase)new EntityFoxhound(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76778_j), EntityFoxhound.FOXHOUND_LOOT_TABLE);
        }
        if (this.isFeatureEnabled(Frogs.class) && JERQuark.jerConfig.JER_MOBS.enableFrog) {
            this.registerMob((EntityLivingBase)new EntityFrog(this.world), LightLevel.any, EntityFrog.FROG_LOOT_TABLE);
        }
        if (this.isFeatureEnabled(PirateShips.class) && !PirateShips.onlyHat && JERQuark.jerConfig.JER_MOBS.enablePirate) {
            EntityPirate pirate = new EntityPirate(this.world);
            pirate.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(Items.field_151040_l));
            pirate.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(PirateShips.pirate_hat));
            List drops = LootTableHelper.toDrops((World)this.world, (ResourceLocation)LootTableList.field_186385_aj);
            drops.add(new LootDrop(PirateShips.pirate_hat, 0, 1, 0.085f, new Conditional[]{Conditional.affectedByLooting}));
            this.registerMob((EntityLivingBase)pirate, LightLevel.any, BiomeHelper.getBiomeNamesForTypes(BiomeDictionary.Type.OCEAN.getName()), drops.toArray(new LootDrop[0]));
        }
        if (this.isFeatureEnabled(Stonelings.class) && JERQuark.jerConfig.JER_MOBS.enableStoneling) {
            List drops = LootTableHelper.toDrops((World)this.world, (ResourceLocation)EntityStoneling.LOOT_TABLE);
            drops.addAll(LootTableHelper.toDrops((World)this.world, (ResourceLocation)EntityStoneling.CARRY_LOOT_TABLE));
            this.registerMob((EntityLivingBase)new EntityStoneling(this.world), LightLevel.hostile, drops.toArray(new LootDrop[0]));
        }
        if (this.isFeatureEnabled(Wraiths.class) && JERQuark.jerConfig.JER_MOBS.enableWraith) {
            this.registerMob((EntityLivingBase)new EntityWraith(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForTypes(BiomeDictionary.Type.NETHER.getName()), EntityWraith.LOOT_TABLE);
        }
    }

    @Override
    public void injectLoot() {
        if (JEMConfig.QUARK.enableJERInjectedLoot) {
            for (MobEntry mobEntry : MobRegistry.getInstance().getMobs()) {
                Set mobEntries;
                Field entryField2;
                if (this.isFeatureEnabled(WitchHat.class) && WitchHat.dropRate > 0.0 && mobEntry.getEntity() instanceof EntityWitch) {
                    try {
                        entryField2 = MobRegistry.getInstance().getClass().getDeclaredField("registry");
                        entryField2.setAccessible(true);
                        mobEntries = (Set)entryField2.get(MobRegistry.getInstance());
                        LootDrop hatDrop = new LootDrop(WitchHat.witch_hat, 0, 1, (float)WitchHat.dropRate, new Conditional[]{Conditional.affectedByLooting});
                        if (WitchHat.verifyTruePlayer) {
                            hatDrop.addConditional(Conditional.playerKill);
                        }
                        mobEntries.remove(mobEntry);
                        mobEntry.addDrop(hatDrop);
                        mobEntries.add(mobEntry);
                        continue;
                    }
                    catch (Exception entryField2) {
                        // empty catch block
                    }
                }
                if (this.isFeatureEnabled(BlackAsh.class) && mobEntry.getEntity() instanceof EntityWither) {
                    try {
                        entryField2 = MobRegistry.getInstance().getClass().getDeclaredField("registry");
                        entryField2.setAccessible(true);
                        mobEntries = (Set)entryField2.get(MobRegistry.getInstance());
                        if (BlackAsh.witherMax > 0) {
                            LootDrop ashDrop = new LootDrop(Item.func_150898_a((Block)BlackAsh.black_ash), BlackAsh.witherMin, BlackAsh.witherMax, new Conditional[0]);
                            mobEntries.remove(mobEntry);
                            mobEntry.addDrop(ashDrop);
                            mobEntries.add(mobEntry);
                        }
                    }
                    catch (Exception entryField3) {
                        // empty catch block
                    }
                }
                if (this.isFeatureEnabled(BlackAsh.class) && mobEntry.getEntity() instanceof EntityWitherSkeleton) {
                    try {
                        entryField2 = MobRegistry.getInstance().getClass().getDeclaredField("registry");
                        entryField2.setAccessible(true);
                        mobEntries = (Set)entryField2.get(MobRegistry.getInstance());
                        mobEntries.remove(mobEntry);
                        Field dropsField = mobEntry.getClass().getDeclaredField("drops");
                        dropsField.setAccessible(true);
                        Set drops = (Set)dropsField.get(mobEntry);
                        if (BlackAsh.removeCoalDrops) {
                            drops.removeIf(drop -> drop.item.func_77973_b().equals(Items.field_151044_h));
                        }
                        mobEntry.addDrop(new LootDrop(Item.func_150898_a((Block)BlackAsh.black_ash), BlackAsh.witherSkeletonMin, BlackAsh.witherSkeletonMax, new Conditional[]{Conditional.affectedByLooting}));
                        mobEntries.add(mobEntry);
                    }
                    catch (Exception entryField4) {
                        // empty catch block
                    }
                }
                if (!this.isFeatureEnabled(TallowAndCandles.class) || !TallowAndCandles.enableTallow || !(mobEntry.getEntity() instanceof EntityPig)) continue;
                try {
                    entryField2 = MobRegistry.getInstance().getClass().getDeclaredField("registry");
                    entryField2.setAccessible(true);
                    mobEntries = (Set)entryField2.get(MobRegistry.getInstance());
                    LootDrop tallowDrop = new LootDrop(TallowAndCandles.tallow, TallowAndCandles.minDrop, TallowAndCandles.maxDrop, new Conditional[0]);
                    mobEntries.remove(mobEntry);
                    mobEntry.addDrop(tallowDrop);
                    mobEntries.add(mobEntry);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void registerModVillagers() {
        if (JERQuark.jerConfig.JER_VILLAGERS.enableArchaeologist && this.isFeatureEnabled(Archaeologist.class)) {
            CustomVillagerRegistry registry = CustomVillagerRegistry.getInstance();
            ArrayList allTrades = new ArrayList();
            ArrayList<BasicTrade> trades = new ArrayList<BasicTrade>();
            trades.add(new BasicTrade(new ItemStack(Items.field_151103_aS, 4), new ItemStack(Items.field_151166_bC, 3)));
            trades.add(new BasicTrade(new ItemStack(Items.field_151166_bC, 1), new ItemStack(Items.field_151103_aS, 12)));
            trades.add(new BasicTrade(new ItemStack(Items.field_151166_bC, 1), new ItemStack(Items.field_151016_H, 12)));
            trades.add(new BasicTrade(new ItemStack(Items.field_151166_bC, 1), new ItemStack(Items.field_151044_h, 20)));
            trades.add(new BasicTrade(new ItemStack(Items.field_151045_i, 1), new ItemStack(Items.field_151166_bC, 16)));
            trades.add(new BasicTrade(new ItemStack(Items.field_151035_b), new ItemStack(Items.field_151166_bC, 6)));
            trades.add(new BasicTrade(new ItemStack(Items.field_151037_a), new ItemStack(Items.field_151166_bC, 5)));
            if (Archaeologist.enableHat && Archaeologist.sellHat) {
                trades.add(new BasicTrade(new ItemStack(Archaeologist.archaeologist_hat), new ItemStack(Items.field_151166_bC, 5)));
            }
            allTrades.add(trades);
            registry.addVillagerEntry(new CustomVillagerEntry("quark:archaeologist", 0, allTrades){

                @Override
                public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) throws IllegalAccessException, InvocationTargetException, InstantiationException {
                    return new EntityArchaeologist(JERQuark.this.world);
                }

                @Override
                public String getDisplayName() {
                    return "entity." + this.getName() + ".name";
                }
            });
        }
    }

    private void registerDungeonLoot(String name) {
        JERDungeonStrings dungeon = new JERDungeonStrings(name);
        this.registerDungeonLoot(dungeon.category, dungeon.unlocName, dungeon.lootTable);
    }

    private boolean isFeatureEnabled(Class<? extends Feature> clazz) {
        Feature feature = (Feature)ModuleLoader.featureInstances.get(clazz);
        return feature != null && feature.isEnabled();
    }

    private static class JERDungeonStrings {
        public final String category;
        public final String unlocName;
        public final ResourceLocation lootTable;

        public JERDungeonStrings(String name) {
            this.category = String.format("%s:chests/%s", ModIds.QUARK.MOD_ID, name);
            this.unlocName = StringHelper.getDungeonTranslationKey(ModIds.QUARK.MOD_ID, name);
            this.lootTable = new ResourceLocation(this.category);
        }
    }
}

