/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigOceanicExpanse;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.util.BiomeHelper;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import com.invadermonky.justenoughmagiculture.util.StringHelper;
import com.sirsquidly.oe.entity.EntityCod;
import com.sirsquidly.oe.entity.EntityCrab;
import com.sirsquidly.oe.entity.EntityDrowned;
import com.sirsquidly.oe.entity.EntityGlowSquid;
import com.sirsquidly.oe.entity.EntityPickled;
import com.sirsquidly.oe.entity.EntityPufferfish;
import com.sirsquidly.oe.entity.EntitySalmon;
import com.sirsquidly.oe.entity.EntityTropicalFish;
import com.sirsquidly.oe.entity.EntityTurtle;
import com.sirsquidly.oe.util.handlers.ConfigHandler;
import com.sirsquidly.oe.util.handlers.LootTableHandler;
import jeresources.api.conditionals.LightLevel;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;

public class JEROceanicExpanse
extends JERBase
implements IJERIntegration {
    JEMConfigOceanicExpanse.JER jerConfig;

    public JEROceanicExpanse(boolean enableJERDungeons, boolean enableJERMobs) {
        this.jerConfig = JEMConfig.OCEANIC_EXPANSE.JUST_ENOUGH_RESOURCES;
        if (enableJERDungeons) {
            this.registerModDungeons();
        }
        if (enableJERMobs) {
            this.registerModEntities();
        }
    }

    @Override
    public void registerModDungeons() {
        if (ConfigHandler.worldGen.shipwreck.enableShipwrecks) {
            this.registerOEDungeon("shipwreck_map", "chests");
            this.registerOEDungeon("shipwreck_supply", "chests");
            this.registerOEDungeon("shipwreck_treasure", "chests");
        }
        if (ConfigHandler.entity.crab.enableCrab) {
            this.registerOEDungeon("crab_dig", "gameplay");
        }
        if (ConfigHandler.worldGen.shellPatch.enableShellPatch) {
            this.registerOEDungeon("shell_sand", "gameplay");
        }
    }

    @Override
    public void registerModEntities() {
        if (this.jerConfig.enableCod && ConfigHandler.entity.cod.enableCod) {
            this.registerMob((EntityLivingBase)new EntityCod(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76771_b), LootTableHandler.ENTITIES_COD);
            this.adjustCreatureRenderHook(EntityCod.class);
        }
        if (this.jerConfig.enableCrab && ConfigHandler.entity.crab.enableCrab) {
            this.registerMob((EntityLivingBase)new EntityCrab(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76787_r), LootTableHandler.ENTITIES_CRAB);
        }
        if (this.jerConfig.enableDrowned && ConfigHandler.entity.drowned.enableDrowned) {
            this.registerMob((EntityLivingBase)new EntityDrowned(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76771_b, Biomes.field_76781_i), LootTableHandler.ENTITIES_DROWNED);
        }
        if (this.jerConfig.enableGlowSquid) {
            this.registerMob((EntityLivingBase)new EntityGlowSquid(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_150575_M), LootTableHandler.ENTITIES_GLOW_SQUID);
        }
        if (this.jerConfig.enablePickled && ConfigHandler.entity.pickled.enablePickled) {
            this.registerMob((EntityLivingBase)new EntityPickled(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76771_b), LootTableHandler.ENTITIES_PICKLED);
        }
        if (this.jerConfig.enablePufferfish && ConfigHandler.entity.pufferfish.enablePufferfish) {
            this.registerMob((EntityLivingBase)new EntityPufferfish(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_150575_M), LootTableHandler.ENTITIES_PUFFERFISH);
            this.adjustCreatureRenderHook(EntityPufferfish.class);
        }
        if (this.jerConfig.enableSalmon && ConfigHandler.entity.salmon.enableSalmon) {
            this.registerMob((EntityLivingBase)new EntitySalmon(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76781_i, Biomes.field_76771_b), LootTableHandler.ENTITIES_SALMON);
            this.adjustCreatureRenderHook(EntitySalmon.class);
        }
        if (this.jerConfig.enableTropicalFish && ConfigHandler.entity.tropicalFish.enableTropicalFish) {
            EntityTropicalFish tropicalFish = new EntityTropicalFish(this.world);
            tropicalFish.setTropicalFishVariant(3);
            this.registerMob((EntityLivingBase)tropicalFish, LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76771_b), LootTableHandler.ENTITIES_TROPICAL_FISH);
            this.adjustCreatureRenderHook(tropicalFish.getClass());
        }
        if (this.jerConfig.enableTurtle && ConfigHandler.entity.turtle.enableTurtle) {
            this.registerMob((EntityLivingBase)new EntityTurtle(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76787_r), LootTableHandler.ENTITIES_TURTLE);
            this.adjustCreatureRenderHook(EntityTurtle.class);
        }
    }

    private void adjustCreatureRenderHook(Class<? extends EntityLiving> clazz) {
        this.registerRenderHook(clazz, (renderInfo, e) -> {
            GlStateManager.func_179137_b((double)0.0, (double)0.5, (double)0.0);
            return renderInfo;
        });
    }

    private void registerOEDungeon(String name, String type) {
        JERDungeonStrings dungeon = new JERDungeonStrings(name, type);
        this.registerDungeonLoot(dungeon.category, dungeon.unlocName, dungeon.lootTable);
    }

    private static class JERDungeonStrings {
        public final String category;
        public final String unlocName;
        public final ResourceLocation lootTable;

        public JERDungeonStrings(String name, String type) {
            this.category = String.format("%s:%s/%s", ModIds.OCEANIC_EXPANSE.MOD_ID, type, name);
            this.unlocName = StringHelper.getDungeonTranslationKey(ModIds.OCEANIC_EXPANSE.MOD_ID, name);
            this.lootTable = new ResourceLocation(this.category);
        }
    }
}

