/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.github.alexthe666.iceandfire.entity.EntityAmphithere;
import com.github.alexthe666.iceandfire.entity.EntityCockatrice;
import com.github.alexthe666.iceandfire.entity.EntityCyclops;
import com.github.alexthe666.iceandfire.entity.EntityDeathWorm;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDreadBeast;
import com.github.alexthe666.iceandfire.entity.EntityDreadGhoul;
import com.github.alexthe666.iceandfire.entity.EntityDreadKnight;
import com.github.alexthe666.iceandfire.entity.EntityDreadLich;
import com.github.alexthe666.iceandfire.entity.EntityDreadScuttler;
import com.github.alexthe666.iceandfire.entity.EntityDreadThrall;
import com.github.alexthe666.iceandfire.entity.EntityFireDragon;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.EntityHippocampus;
import com.github.alexthe666.iceandfire.entity.EntityHippogryph;
import com.github.alexthe666.iceandfire.entity.EntityHydra;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexQueen;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexRoyal;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexSentinel;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexSoldier;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexWorker;
import com.github.alexthe666.iceandfire.entity.EntityPixie;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpent;
import com.github.alexthe666.iceandfire.entity.EntitySiren;
import com.github.alexthe666.iceandfire.entity.EntitySnowVillager;
import com.github.alexthe666.iceandfire.entity.EntityStymphalianBird;
import com.github.alexthe666.iceandfire.entity.EntityTroll;
import com.github.alexthe666.iceandfire.entity.IafVillagerRegistry;
import com.github.alexthe666.iceandfire.enums.EnumTroll;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.world.gen.WorldGenCyclopsCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenFireDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenHydraCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenIceDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexDecoration;
import com.google.common.collect.Sets;
import com.invadermonky.justenoughmagiculture.client.model.entity.mods.iceandfire.JERRenderHippocampus;
import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigIceAndFire;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.jer.villager.CustomVanillaVillagerEntry;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.registry.CustomVillagerRegistry;
import com.invadermonky.justenoughmagiculture.util.BiomeHelper;
import com.invadermonky.justenoughmagiculture.util.LogHelper;
import com.invadermonky.justenoughmagiculture.util.ReflectionHelper;
import com.invadermonky.justenoughmagiculture.util.StringHelper;
import com.invadermonky.justenoughmagiculture.util.modhelpers.IaFLootHelper;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import jeresources.api.conditionals.Conditional;
import jeresources.api.conditionals.LightLevel;
import jeresources.api.drop.LootDrop;
import jeresources.entry.MobEntry;
import jeresources.registry.MobRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import org.apache.commons.lang3.reflect.FieldUtils;

public class JERIceAndFire
extends JERBase
implements IJERIntegration {
    private static JERIceAndFire instance;
    JEMConfigIceAndFire.JER jerConfig;

    private JERIceAndFire() {
        this.jerConfig = JEMConfig.ICE_AND_FIRE.JUST_ENOUGH_RESOURCES;
    }

    public JERIceAndFire(boolean enableJERDungeons, boolean enableJERMobs, boolean enableJERVillagers) {
        this.jerConfig = JEMConfig.ICE_AND_FIRE.JUST_ENOUGH_RESOURCES;
        if (enableJERDungeons) {
            this.registerModDungeons();
        }
        if (enableJERMobs) {
            this.registerModEntities();
        }
        if (enableJERVillagers) {
            this.registerModVillagers();
        }
        JERIceAndFire.getInstance();
    }

    public static JERIceAndFire getInstance() {
        return instance != null ? instance : (instance = new JERIceAndFire());
    }

    public void lateInit() {
        this.registerRenderOverrides();
        this.injectLoot();
    }

    @Override
    public void registerModDungeons() {
        this.registerIAFDungeon(WorldGenCyclopsCave.CYCLOPS_CHEST);
        this.registerIAFDungeon(WorldGenFireDragonCave.FIREDRAGON_CHEST);
        this.registerIAFDungeon(WorldGenFireDragonCave.FIREDRAGON_MALE_CHEST);
        this.registerIAFDungeon(WorldGenHydraCave.HYDRA_CHEST);
        this.registerIAFDungeon(WorldGenIceDragonCave.ICEDRAGON_CHEST);
        this.registerIAFDungeon(WorldGenIceDragonCave.ICEDRAGON_MALE_CHEST);
        this.registerIAFDungeon(WorldGenMyrmexDecoration.DESERT_MYRMEX_FOOD_CHEST);
        this.registerIAFDungeon(WorldGenMyrmexDecoration.JUNGLE_MYRMEX_FOOD_CHEST);
        this.registerIAFDungeon(WorldGenMyrmexDecoration.MYRMEX_GOLD_CHEST);
        this.registerIAFDungeon(WorldGenMyrmexDecoration.MYRMEX_TRASH_CHEST);
    }

    @Override
    public void registerModEntities() {
        this.registerDragons();
        this.registerDeathworms();
        this.registerDread();
        this.registerMyrmex();
        this.registerSeaSerpents();
        this.registerMiscMobs();
    }

    @Override
    public void injectLoot() {
        if (JEMConfig.ICE_AND_FIRE.enableJERInjectedLoot) {
            for (MobEntry mobEntry : MobRegistry.getInstance().getMobs()) {
                if (!(mobEntry.getEntity() instanceof EntityWitherSkeleton)) continue;
                try {
                    Field entryField = MobRegistry.getInstance().getClass().getDeclaredField("registry");
                    entryField.setAccessible(true);
                    Set mobEntries = (Set)entryField.get(MobRegistry.getInstance());
                    mobEntries.remove(mobEntry);
                    Field dropsField = mobEntry.getClass().getDeclaredField("drops");
                    dropsField.setAccessible(true);
                    mobEntry.addDrop(new LootDrop(IafItemRegistry.witherbone, 0, 1, new Conditional[0]));
                    mobEntries.add(mobEntry);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void registerDragons() {
        List<LootDrop> femaleDrops;
        EntityIceDragon iceDragon;
        EntityFireDragon fireDragon;
        int i;
        THashSet validFireTypes = new THashSet((Collection)Sets.newHashSet((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN}));
        THashSet invalidForeTypes = new THashSet((Collection)Sets.newHashSet((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY}));
        THashSet<Biome> validIceBiomes = this.getIaFLinkedBiomes(BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY);
        THashSet invalidIceTypes = new THashSet((Collection)Sets.newHashSet((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.BEACH}));
        if (this.jerConfig.JER_MOBS.enableFireDragonMale) {
            for (i = 0; i < 3; ++i) {
                fireDragon = new EntityFireDragon(this.world);
                fireDragon.setVariant(i);
                fireDragon.func_96094_a("entity.jem:iaf_fire_dragon_male.name");
                List<LootDrop> drops = IaFLootHelper.toDrops((EntityLivingBase)fireDragon, this.manager.func_186521_a(EntityFireDragon.MALE_LOOT));
                if (!this.jerConfig.JER_MOBS.enableFireDragonMale) continue;
                this.registerMob((EntityLivingBase)fireDragon, LightLevel.any, this.getIaFSpawnBiomesFromTypes((THashSet<BiomeDictionary.Type>)validFireTypes, (THashSet<BiomeDictionary.Type>)invalidForeTypes), drops);
            }
        }
        if (this.jerConfig.JER_MOBS.enableIceDragonMale) {
            for (i = 0; i < 3; ++i) {
                iceDragon = new EntityIceDragon(this.world);
                iceDragon.setVariant(i);
                iceDragon.func_96094_a("entity.jem:iaf_ice_dragon_male.name");
                THashSet<Biome> validBiomes = this.getIaFLinkedBiomes(BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY);
                List<LootDrop> drops = IaFLootHelper.toDrops((EntityLivingBase)iceDragon, this.manager.func_186521_a(EntityIceDragon.MALE_LOOT));
                if (!this.jerConfig.JER_MOBS.enableFireDragonMale) continue;
                this.registerMob((EntityLivingBase)iceDragon, LightLevel.any, BiomeHelper.getBiomeNamesForBiomes((Biome[])validBiomes.toArray((Object[])new Biome[0])), drops);
            }
        }
        if (this.jerConfig.JER_MOBS.enableFireDragonFemale) {
            for (i = 0; i < 3; ++i) {
                fireDragon = new EntityFireDragon(this.world);
                fireDragon.setVariant(i);
                fireDragon.func_96094_a("entity.jem:iaf_fire_dragon_female.name");
                femaleDrops = IaFLootHelper.toDrops((EntityLivingBase)fireDragon, this.manager.func_186521_a(EntityFireDragon.FEMALE_LOOT));
                this.registerMob((EntityLivingBase)fireDragon, LightLevel.any, this.getIaFSpawnBiomesFromTypes((THashSet<BiomeDictionary.Type>)validFireTypes, (THashSet<BiomeDictionary.Type>)invalidForeTypes), femaleDrops);
            }
        }
        if (this.jerConfig.JER_MOBS.enableIceDragonFemale) {
            for (i = 0; i < 3; ++i) {
                iceDragon = new EntityIceDragon(this.world);
                iceDragon.setVariant(i);
                iceDragon.func_96094_a("entity.jem:iaf_ice_dragon_female.name");
                femaleDrops = IaFLootHelper.toDrops((EntityLivingBase)iceDragon, this.manager.func_186521_a(EntityIceDragon.FEMALE_LOOT));
                this.registerMob((EntityLivingBase)iceDragon, LightLevel.any, this.getIaFSpawnBiomes(validIceBiomes, (THashSet<BiomeDictionary.Type>)invalidIceTypes), femaleDrops);
            }
        }
        this.registerRenderHook(EntityDragonBase.class, (renderInfo, e) -> {
            GlStateManager.func_179139_a((double)3.0, (double)3.0, (double)3.0);
            GlStateManager.func_179137_b((double)-0.005, (double)-0.05, (double)0.0);
            return renderInfo;
        });
    }

    private void registerDeathworms() {
        List<LootDrop> drops;
        THashSet invalidTypes;
        THashSet validTypes;
        EntityDeathWorm deathWorm;
        if (this.jerConfig.JER_MOBS.enableDeathWormRed) {
            deathWorm = new EntityDeathWorm(this.world);
            deathWorm.setVariant(2);
            deathWorm.setWormAge(5);
            validTypes = new THashSet((Collection)Sets.newHashSet((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SANDY, BiomeDictionary.Type.DRY}));
            invalidTypes = new THashSet((Collection)Sets.newHashSet((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.BEACH, BiomeDictionary.Type.MESA}));
            drops = IaFLootHelper.toDrops((EntityLivingBase)deathWorm, this.manager.func_186521_a(EntityDeathWorm.RED_LOOT));
            this.registerMob((EntityLivingBase)deathWorm, LightLevel.any, this.getIaFSpawnBiomesFromTypes((THashSet<BiomeDictionary.Type>)validTypes, (THashSet<BiomeDictionary.Type>)invalidTypes), drops);
        }
        if (this.jerConfig.JER_MOBS.enableDeathWormRedGiant) {
            deathWorm = new EntityDeathWorm(this.world);
            deathWorm.setVariant(2);
            deathWorm.setWormAge(10);
            validTypes = new THashSet((Collection)Sets.newHashSet((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SANDY, BiomeDictionary.Type.DRY}));
            invalidTypes = new THashSet((Collection)Sets.newHashSet((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.BEACH, BiomeDictionary.Type.MESA}));
            drops = IaFLootHelper.toDrops((EntityLivingBase)deathWorm, this.manager.func_186521_a(EntityDeathWorm.RED_GIANT_LOOT));
            this.registerMob((EntityLivingBase)deathWorm, LightLevel.any, this.getIaFSpawnBiomesFromTypes((THashSet<BiomeDictionary.Type>)validTypes, (THashSet<BiomeDictionary.Type>)invalidTypes), drops);
        }
        if (this.jerConfig.JER_MOBS.enableDeathWormTan) {
            deathWorm = new EntityDeathWorm(this.world);
            deathWorm.setVariant(0);
            deathWorm.setWormAge(5);
            validTypes = new THashSet((Collection)Sets.newHashSet((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SANDY, BiomeDictionary.Type.DRY}));
            invalidTypes = new THashSet((Collection)Sets.newHashSet((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.BEACH, BiomeDictionary.Type.MESA}));
            drops = IaFLootHelper.toDrops((EntityLivingBase)deathWorm, this.manager.func_186521_a(EntityDeathWorm.TAN_LOOT));
            this.registerMob((EntityLivingBase)deathWorm, LightLevel.any, this.getIaFSpawnBiomesFromTypes((THashSet<BiomeDictionary.Type>)validTypes, (THashSet<BiomeDictionary.Type>)invalidTypes), drops);
        }
        if (this.jerConfig.JER_MOBS.enableDeathWormTanGiant) {
            deathWorm = new EntityDeathWorm(this.world);
            deathWorm.setVariant(0);
            deathWorm.setWormAge(10);
            validTypes = new THashSet((Collection)Sets.newHashSet((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SANDY, BiomeDictionary.Type.DRY}));
            invalidTypes = new THashSet((Collection)Sets.newHashSet((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.BEACH, BiomeDictionary.Type.MESA}));
            drops = IaFLootHelper.toDrops((EntityLivingBase)deathWorm, this.manager.func_186521_a(EntityDeathWorm.TAN_GIANT_LOOT));
            this.registerMob((EntityLivingBase)deathWorm, LightLevel.any, this.getIaFSpawnBiomesFromTypes((THashSet<BiomeDictionary.Type>)validTypes, (THashSet<BiomeDictionary.Type>)invalidTypes), drops);
        }
        if (this.jerConfig.JER_MOBS.enableDeathWormWhite) {
            deathWorm = new EntityDeathWorm(this.world);
            deathWorm.setVariant(1);
            deathWorm.setWormAge(5);
            validTypes = new THashSet((Collection)Sets.newHashSet((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SANDY, BiomeDictionary.Type.DRY}));
            invalidTypes = new THashSet((Collection)Sets.newHashSet((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.BEACH, BiomeDictionary.Type.MESA}));
            drops = IaFLootHelper.toDrops((EntityLivingBase)deathWorm, this.manager.func_186521_a(EntityDeathWorm.WHITE_LOOT));
            this.registerMob((EntityLivingBase)deathWorm, LightLevel.any, this.getIaFSpawnBiomesFromTypes((THashSet<BiomeDictionary.Type>)validTypes, (THashSet<BiomeDictionary.Type>)invalidTypes), drops);
        }
        if (this.jerConfig.JER_MOBS.enableDeathWormWhiteGiant) {
            deathWorm = new EntityDeathWorm(this.world);
            deathWorm.setVariant(1);
            deathWorm.setWormAge(10);
            validTypes = new THashSet((Collection)Sets.newHashSet((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SANDY, BiomeDictionary.Type.DRY}));
            invalidTypes = new THashSet((Collection)Sets.newHashSet((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.BEACH, BiomeDictionary.Type.MESA}));
            drops = IaFLootHelper.toDrops((EntityLivingBase)deathWorm, this.manager.func_186521_a(EntityDeathWorm.WHITE_GIANT_LOOT));
            this.registerMob((EntityLivingBase)deathWorm, LightLevel.any, this.getIaFSpawnBiomesFromTypes((THashSet<BiomeDictionary.Type>)validTypes, (THashSet<BiomeDictionary.Type>)invalidTypes), drops);
        }
    }

    private void registerDread() {
        THashSet<Biome> validBiomes;
        if (this.jerConfig.JER_MOBS.enableDreadBeast) {
            EntityDreadBeast dreadBeast = new EntityDreadBeast(this.world);
            validBiomes = this.getIaFLinkedBiomes(BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY);
            this.registerMob((EntityLivingBase)dreadBeast, LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes((Biome[])validBiomes.toArray((Object[])new Biome[0])), EntityDreadBeast.LOOT);
            this.adjustHumanoidRenderHook(EntityDreadBeast.class);
        }
        if (this.jerConfig.JER_MOBS.enableDreadGhoul) {
            EntityDreadGhoul dreadGhoul = new EntityDreadGhoul(this.world);
            validBiomes = this.getIaFLinkedBiomes(BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY);
            this.registerMob((EntityLivingBase)dreadGhoul, LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes((Biome[])validBiomes.toArray((Object[])new Biome[0])), EntityDreadGhoul.LOOT);
            this.adjustHumanoidRenderHook(EntityDreadGhoul.class);
        }
        if (this.jerConfig.JER_MOBS.enableDreadKnight) {
            EntityDreadKnight dreadKnight = new EntityDreadKnight(this.world);
            dreadKnight.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(IafItemRegistry.dread_knight_sword));
            validBiomes = this.getIaFLinkedBiomes(BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY);
            this.registerMob((EntityLivingBase)dreadKnight, LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes((Biome[])validBiomes.toArray((Object[])new Biome[0])), EntityDreadKnight.LOOT);
            this.registerRenderHook(EntityDreadKnight.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)-0.05, (double)0.2, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableDreadLich) {
            EntityDreadLich lich = new EntityDreadLich(this.world);
            lich.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(IafItemRegistry.lich_staff));
            validBiomes = this.getIaFLinkedBiomes(BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY);
            this.registerMob((EntityLivingBase)lich, LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes((Biome[])validBiomes.toArray((Object[])new Biome[0])), EntityDreadLich.LOOT);
            this.adjustHumanoidRenderHook(EntityDreadLich.class);
        }
        if (this.jerConfig.JER_MOBS.enableDreadScuttler) {
            EntityDreadScuttler dreadScuttler = new EntityDreadScuttler(this.world);
            validBiomes = this.getIaFLinkedBiomes(BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY);
            this.registerMob((EntityLivingBase)dreadScuttler, LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes((Biome[])validBiomes.toArray((Object[])new Biome[0])), EntityDreadScuttler.LOOT);
            this.registerRenderHook(EntityDreadScuttler.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
                GlStateManager.func_179137_b((double)0.0, (double)-0.2, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableDreadThrall) {
            EntityDreadThrall dreadThrall = new EntityDreadThrall(this.world);
            dreadThrall.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(IafItemRegistry.dread_sword));
            dreadThrall.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack((Item)Items.field_151020_U));
            dreadThrall.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack((Item)Items.field_151023_V));
            dreadThrall.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack((Item)Items.field_151022_W));
            dreadThrall.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack((Item)Items.field_151029_X));
            validBiomes = this.getIaFLinkedBiomes(BiomeDictionary.Type.COLD, BiomeDictionary.Type.SNOWY);
            this.registerMob((EntityLivingBase)dreadThrall, LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes((Biome[])validBiomes.toArray((Object[])new Biome[0])), EntityDreadThrall.LOOT);
            this.adjustHumanoidRenderHook(dreadThrall.getClass());
        }
    }

    private void registerMyrmex() {
        THashSet<Biome> validBiomes;
        if (this.jerConfig.JER_MOBS.enableMyrmexDesertQueen) {
            validBiomes = this.getIaFLinkedBiomes(BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY);
            this.registerMob((EntityLivingBase)this.setMyrmexTexture((EntityMyrmexBase)new EntityMyrmexQueen(this.world), false), LightLevel.any, BiomeHelper.getBiomeNamesForBiomes((Biome[])validBiomes.toArray((Object[])new Biome[0])), EntityMyrmexQueen.DESERT_LOOT);
        }
        if (this.jerConfig.JER_MOBS.enableMyrmexDesertRoyal) {
            validBiomes = this.getIaFLinkedBiomes(BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY);
            this.registerMob((EntityLivingBase)this.setMyrmexTexture((EntityMyrmexBase)new EntityMyrmexRoyal(this.world), false), LightLevel.any, BiomeHelper.getBiomeNamesForBiomes((Biome[])validBiomes.toArray((Object[])new Biome[0])), EntityMyrmexRoyal.DESERT_LOOT);
        }
        if (this.jerConfig.JER_MOBS.enableMyrmexDesertSentinel) {
            validBiomes = this.getIaFLinkedBiomes(BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY);
            this.registerMob((EntityLivingBase)this.setMyrmexTexture((EntityMyrmexBase)new EntityMyrmexSentinel(this.world), false), LightLevel.any, BiomeHelper.getBiomeNamesForBiomes((Biome[])validBiomes.toArray((Object[])new Biome[0])), EntityMyrmexSentinel.DESERT_LOOT);
        }
        if (this.jerConfig.JER_MOBS.enableMyrmexDesertSoldier) {
            validBiomes = this.getIaFLinkedBiomes(BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY);
            this.registerMob((EntityLivingBase)this.setMyrmexTexture((EntityMyrmexBase)new EntityMyrmexSoldier(this.world), false), LightLevel.any, BiomeHelper.getBiomeNamesForBiomes((Biome[])validBiomes.toArray((Object[])new Biome[0])), EntityMyrmexSoldier.DESERT_LOOT);
        }
        if (this.jerConfig.JER_MOBS.enableMyrmexDesertWorker) {
            validBiomes = this.getIaFLinkedBiomes(BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SANDY);
            this.registerMob((EntityLivingBase)this.setMyrmexTexture((EntityMyrmexBase)new EntityMyrmexWorker(this.world), false), LightLevel.any, BiomeHelper.getBiomeNamesForBiomes((Biome[])validBiomes.toArray((Object[])new Biome[0])), EntityMyrmexWorker.DESERT_LOOT);
        }
        if (this.jerConfig.JER_MOBS.enableMyrmexJungleQueen) {
            this.registerMob((EntityLivingBase)this.setMyrmexTexture((EntityMyrmexBase)new EntityMyrmexQueen(this.world), true), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(BiomeDictionary.Type.JUNGLE), EntityMyrmexQueen.JUNGLE_LOOT);
        }
        if (this.jerConfig.JER_MOBS.enableMyrmexJungleRoyal) {
            this.registerMob((EntityLivingBase)this.setMyrmexTexture((EntityMyrmexBase)new EntityMyrmexRoyal(this.world), true), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(BiomeDictionary.Type.JUNGLE), EntityMyrmexRoyal.JUNGLE_LOOT);
        }
        if (this.jerConfig.JER_MOBS.enableMyrmexJungleSentinel) {
            this.registerMob((EntityLivingBase)this.setMyrmexTexture((EntityMyrmexBase)new EntityMyrmexSentinel(this.world), true), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(BiomeDictionary.Type.JUNGLE), EntityMyrmexSentinel.JUNGLE_LOOT);
        }
        if (this.jerConfig.JER_MOBS.enableMyrmexJungleSoldier) {
            this.registerMob((EntityLivingBase)this.setMyrmexTexture((EntityMyrmexBase)new EntityMyrmexSoldier(this.world), true), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(BiomeDictionary.Type.JUNGLE), EntityMyrmexSoldier.JUNGLE_LOOT);
        }
        if (this.jerConfig.JER_MOBS.enableMyrmexJungleWorker) {
            this.registerMob((EntityLivingBase)this.setMyrmexTexture((EntityMyrmexBase)new EntityMyrmexWorker(this.world), true), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(BiomeDictionary.Type.JUNGLE), EntityMyrmexWorker.JUNGLE_LOOT);
        }
        this.registerRenderHook(EntityMyrmexQueen.class, (renderInfo, entityLivingBase) -> {
            GlStateManager.func_179139_a((double)1.7, (double)1.7, (double)1.7);
            return renderInfo;
        });
    }

    private void registerSeaSerpents() {
        if (this.jerConfig.JER_MOBS.enableSeaSerpent) {
            for (int i = 0; i < 6; ++i) {
                EntitySeaSerpent seaSerpent = new EntitySeaSerpent(this.world);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74776_a("Scale", 1.0f);
                seaSerpent.func_70037_a(tag);
                seaSerpent.setVariant(i);
                List<LootDrop> drops = IaFLootHelper.toDrops((EntityLivingBase)seaSerpent, this.manager.func_186521_a(EntitySeaSerpent.LOOT));
                this.registerMob((EntityLivingBase)seaSerpent, LightLevel.any, BiomeHelper.getBiomeNamesForTypes(BiomeDictionary.Type.OCEAN), drops);
            }
        }
    }

    private void registerMiscMobs() {
        EntityTroll troll;
        if (this.jerConfig.JER_MOBS.enableAmphithere) {
            this.registerMob((EntityLivingBase)new EntityAmphithere(this.world), LightLevel.any, BiomeHelper.getTypeNamesForTypes(BiomeDictionary.Type.JUNGLE), EntityAmphithere.LOOT);
            this.registerRenderHook(EntityAmphithere.class, (renderInfo, entityLivingBase) -> {
                GlStateManager.func_179137_b((double)-0.05, (double)1.4, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableCockatrice) {
            this.registerMob((EntityLivingBase)new EntityCockatrice(this.world), LightLevel.any, BiomeHelper.getTypeNamesForTypes(BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.SPARSE), EntityCockatrice.LOOT);
        }
        if (this.jerConfig.JER_MOBS.enableCyclops) {
            this.registerMob((EntityLivingBase)new EntityCyclops(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(BiomeDictionary.Type.BEACH, BiomeDictionary.Type.PLAINS), EntityCyclops.LOOT);
            this.registerRenderHook(EntityCyclops.class, (renderInfo, entityLivingBase) -> {
                GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
                GlStateManager.func_179137_b((double)-0.05, (double)-1.75, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableGorgon) {
            this.registerMob((EntityLivingBase)new EntityGorgon(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(BiomeDictionary.Type.BEACH), EntityGorgon.LOOT);
            this.adjustHumanoidRenderHook(EntityGorgon.class);
        }
        if (this.jerConfig.JER_MOBS.enableHippocampus) {
            this.registerMob((EntityLivingBase)new EntityHippocampus(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(BiomeDictionary.Type.OCEAN), EntityHippocampus.LOOT);
        }
        if (this.jerConfig.JER_MOBS.enableHippogryph) {
            this.registerMob((EntityLivingBase)new EntityHippogryph(this.world), LightLevel.any, BiomeHelper.getTypeNamesForTypes(BiomeDictionary.Type.HILLS), EntityHippogryph.LOOT);
        }
        if (this.jerConfig.JER_MOBS.enableHydra) {
            this.registerMob((EntityLivingBase)new EntityHydra(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(BiomeDictionary.Type.SWAMP), EntityHydra.LOOT);
            this.registerRenderHook(EntityHydra.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.75, (double)1.75, (double)1.75);
                GlStateManager.func_179137_b((double)-0.05, (double)-0.4, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enablePixie) {
            THashSet<Biome> validBiomes = this.getIaFLinkedBiomes(BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPOOKY);
            validBiomes.addAll((Collection)BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL));
            this.registerMob((EntityLivingBase)new EntityPixie(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForBiomes((Biome[])validBiomes.toArray((Object[])new Biome[0])), EntityPixie.LOOT);
        }
        if (this.jerConfig.JER_MOBS.enableSiren) {
            THashSet validTypes = new THashSet((Collection)Sets.newHashSet((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.OCEAN}));
            THashSet invalidTypes = new THashSet((Collection)Sets.newHashSet((Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD}));
            this.registerMob((EntityLivingBase)new EntitySiren(this.world), LightLevel.any, this.getIaFSpawnBiomesFromTypes((THashSet<BiomeDictionary.Type>)validTypes, (THashSet<BiomeDictionary.Type>)invalidTypes), EntitySiren.LOOT);
        }
        if (this.jerConfig.JER_MOBS.enableStymphalianBird) {
            this.registerMob((EntityLivingBase)new EntityStymphalianBird(this.world), LightLevel.any, BiomeHelper.getBiomeNamesForTypes(BiomeDictionary.Type.SWAMP), EntityStymphalianBird.LOOT);
            this.registerRenderHook(EntityStymphalianBird.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.75, (double)1.75, (double)1.75);
                GlStateManager.func_179137_b((double)-0.05, (double)-0.3, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.JER_MOBS.enableTrollForest) {
            troll = new EntityTroll(this.world);
            troll.setType(EnumTroll.FOREST);
            this.registerMob((EntityLivingBase)troll, LightLevel.hostile, BiomeHelper.getTypeNamesForTypes(troll.getType().spawnBiome), EntityTroll.FOREST_LOOT);
        }
        if (this.jerConfig.JER_MOBS.enableTrollFrost) {
            troll = new EntityTroll(this.world);
            troll.setType(EnumTroll.FROST);
            this.registerMob((EntityLivingBase)troll, LightLevel.hostile, BiomeHelper.getTypeNamesForTypes(troll.getType().spawnBiome), EntityTroll.FROST_LOOT);
        }
        if (this.jerConfig.JER_MOBS.enableTrollMountain) {
            troll = new EntityTroll(this.world);
            troll.setType(EnumTroll.MOUNTAIN);
            this.registerMob((EntityLivingBase)troll, LightLevel.hostile, BiomeHelper.getTypeNamesForTypes(troll.getType().spawnBiome), EntityTroll.MOUNTAIN_LOOT);
        }
        this.registerRenderHook(EntityTroll.class, (renderInfo, e) -> {
            GlStateManager.func_179137_b((double)-0.05, (double)-0.8, (double)0.0);
            return renderInfo;
        });
    }

    public void registerRenderOverrides() {
        if (JEMConfig.ICE_AND_FIRE.enableRenderFixes) {
            RenderingRegistry.registerEntityRenderingHandler(EntityHippocampus.class, (Render)new JERRenderHippocampus(Minecraft.func_71410_x().func_175598_ae()));
        }
    }

    private THashSet<Biome> getIaFLinkedBiomes(BiomeDictionary.Type ... types) {
        THashSet biomes = new THashSet();
        for (BiomeDictionary.Type type : types) {
            if (biomes.isEmpty()) {
                biomes.addAll((Collection)BiomeDictionary.getBiomes((BiomeDictionary.Type)type));
                continue;
            }
            biomes.removeIf(biome -> !BiomeDictionary.getBiomes((BiomeDictionary.Type)type).contains(biome));
        }
        return biomes;
    }

    private String[] getIaFSpawnBiomesFromTypes(THashSet<BiomeDictionary.Type> validTypes, THashSet<BiomeDictionary.Type> invalidTypes) {
        String[] stringArray;
        THashSet validBiomes = new THashSet();
        for (BiomeDictionary.Type validType : validTypes) {
            validBiomes.addAll((Collection)BiomeDictionary.getBiomes((BiomeDictionary.Type)validType));
        }
        for (BiomeDictionary.Type invalidType : invalidTypes) {
            validBiomes.removeAll((Collection)BiomeDictionary.getBiomes((BiomeDictionary.Type)invalidType));
        }
        if (validBiomes.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "jer.any";
        } else {
            stringArray = BiomeHelper.getBiomeNamesForBiomes((Biome[])validBiomes.toArray((Object[])new Biome[0]));
        }
        return stringArray;
    }

    private String[] getIaFSpawnBiomes(THashSet<Biome> biomes, THashSet<BiomeDictionary.Type> invalidTypes) {
        String[] stringArray;
        for (BiomeDictionary.Type type : invalidTypes) {
            biomes.removeAll((Collection)BiomeDictionary.getBiomes((BiomeDictionary.Type)type));
        }
        if (biomes.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "jer.any";
        } else {
            stringArray = BiomeHelper.getBiomeNamesForBiomes((Biome[])biomes.toArray((Object[])new Biome[0]));
        }
        return stringArray;
    }

    private void adjustHumanoidRenderHook(Class<? extends EntityLivingBase> clazz) {
        this.registerRenderHook(clazz, (renderInfo, e) -> {
            GlStateManager.func_179137_b((double)-0.05, (double)-0.4, (double)0.0);
            return renderInfo;
        });
    }

    @Override
    public void registerModVillagers() {
        CustomVillagerRegistry registry = CustomVillagerRegistry.getInstance();
        THashMap desertMyrmexVillagers = new THashMap(5);
        THashMap jungleMyrmexVillagers = new THashMap(5);
        if (this.jerConfig.JER_VILLAGERS.enableMyrmexQueen) {
            desertMyrmexVillagers.put((Object)IafVillagerRegistry.INSTANCE.desertMyrmexQueen, (Object)this.setMyrmexTexture((EntityMyrmexBase)new EntityMyrmexQueen(this.world), false));
            jungleMyrmexVillagers.put((Object)IafVillagerRegistry.INSTANCE.jungleMyrmexQueen, (Object)this.setMyrmexTexture((EntityMyrmexBase)new EntityMyrmexQueen(this.world), true));
        }
        if (this.jerConfig.JER_VILLAGERS.enableMyrmexRoyal) {
            desertMyrmexVillagers.put((Object)IafVillagerRegistry.INSTANCE.desertMyrmexRoyal, (Object)this.setMyrmexTexture((EntityMyrmexBase)new EntityMyrmexRoyal(this.world), false));
            jungleMyrmexVillagers.put((Object)IafVillagerRegistry.INSTANCE.jungleMyrmexRoyal, (Object)this.setMyrmexTexture((EntityMyrmexBase)new EntityMyrmexRoyal(this.world), true));
        }
        if (this.jerConfig.JER_VILLAGERS.enableMyrmexSentinel) {
            desertMyrmexVillagers.put((Object)IafVillagerRegistry.INSTANCE.desertMyrmexSentinel, (Object)this.setMyrmexTexture((EntityMyrmexBase)new EntityMyrmexSentinel(this.world), false));
            jungleMyrmexVillagers.put((Object)IafVillagerRegistry.INSTANCE.jungleMyrmexSentinel, (Object)this.setMyrmexTexture((EntityMyrmexBase)new EntityMyrmexSentinel(this.world), true));
        }
        if (this.jerConfig.JER_VILLAGERS.enableMyrmexSoldier) {
            desertMyrmexVillagers.put((Object)IafVillagerRegistry.INSTANCE.desertMyrmexSoldier, (Object)this.setMyrmexTexture((EntityMyrmexBase)new EntityMyrmexSoldier(this.world), false));
            jungleMyrmexVillagers.put((Object)IafVillagerRegistry.INSTANCE.jungleMyrmexSoldier, (Object)this.setMyrmexTexture((EntityMyrmexBase)new EntityMyrmexSoldier(this.world), true));
        }
        if (this.jerConfig.JER_VILLAGERS.enableMyrmexWorker) {
            desertMyrmexVillagers.put((Object)IafVillagerRegistry.INSTANCE.desertMyrmexWorker, (Object)this.setMyrmexTexture((EntityMyrmexBase)new EntityMyrmexWorker(this.world), false));
            jungleMyrmexVillagers.put((Object)IafVillagerRegistry.INSTANCE.jungleMyrmexWorker, (Object)this.setMyrmexTexture((EntityMyrmexBase)new EntityMyrmexWorker(this.world), true));
        }
        this.registerMyrmexVillagers(registry, (THashMap<VillagerRegistry.VillagerProfession, EntityMyrmexBase>)desertMyrmexVillagers);
        this.registerMyrmexVillagers(registry, (THashMap<VillagerRegistry.VillagerProfession, EntityMyrmexBase>)jungleMyrmexVillagers);
        if (this.jerConfig.JER_VILLAGERS.enableSnowVillager) {
            this.registerSnowVillagers(registry);
        }
    }

    private EntityMyrmexBase setMyrmexTexture(EntityMyrmexBase entity, boolean isJungle) {
        entity.setJungleVariant(isJungle);
        return entity;
    }

    private void registerMyrmexVillagers(CustomVillagerRegistry registry, THashMap<VillagerRegistry.VillagerProfession, EntityMyrmexBase> myrmexVillagers) {
        myrmexVillagers.forEach((profession, villager) -> {
            try {
                VillagerRegistry.VillagerCareer career = profession.getCareer(0);
                List trades = (List)ReflectionHelper.getFieldObject(career, "trades");
                registry.addVillagerEntry(new CustomVanillaVillagerEntry(career.getName(), 0, trades, (EntityMyrmexBase)villager){
                    final /* synthetic */ EntityMyrmexBase val$villager;
                    {
                        this.val$villager = entityMyrmexBase;
                        super(x0, x1, x2);
                    }

                    @Override
                    public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) throws IllegalAccessException, InvocationTargetException, InstantiationException {
                        return this.val$villager;
                    }

                    @Override
                    public String getDisplayName() {
                        return this.val$villager.func_145748_c_().func_150254_d();
                    }

                    @Override
                    public float getRenderScale() {
                        if (this.val$villager instanceof EntityMyrmexQueen) {
                            return 20.0f;
                        }
                        if (this.val$villager instanceof EntityMyrmexRoyal) {
                            return 20.0f;
                        }
                        if (this.val$villager instanceof EntityMyrmexSentinel) {
                            return 30.0f;
                        }
                        if (this.val$villager instanceof EntityMyrmexSoldier) {
                            return 36.0f;
                        }
                        return 36.0f;
                    }
                });
            }
            catch (Exception e) {
                LogHelper.warn(String.format("Failed to register %s villager.", villager.func_70005_c_()));
            }
        });
    }

    private void registerSnowVillagers(CustomVillagerRegistry registry) {
        Map iafProfessions = IafVillagerRegistry.INSTANCE.professions;
        iafProfessions.forEach((id, profession) -> {
            try {
                final EntitySnowVillager snowVillager = new EntitySnowVillager(this.world);
                FieldUtils.writeDeclaredField((Object)snowVillager, (String)"prof", (Object)profession, (boolean)true);
                VillagerRegistry.VillagerCareer career = profession.getCareer(0);
                List trades = (List)ReflectionHelper.getFieldObject(career, "trades");
                registry.addVillagerEntry(new CustomVanillaVillagerEntry(career.getName(), (int)id, trades){

                    @Override
                    public EntityLivingBase getEntity(@Nonnull Minecraft minecraft) throws IllegalAccessException, InvocationTargetException, InstantiationException {
                        return snowVillager;
                    }

                    @Override
                    public String getDisplayName() {
                        return snowVillager.func_145748_c_().func_150254_d();
                    }
                });
            }
            catch (Exception e) {
                LogHelper.warn(String.format("Failed to register Snow Villager %s", profession.getRegistryName().toString()));
            }
        });
    }

    private void registerIAFDungeon(ResourceLocation lootTable) {
        JERDungeonStrings dungeon = new JERDungeonStrings(lootTable);
        this.registerDungeonLoot(dungeon.category, dungeon.unlocName, lootTable);
    }

    public static class JERDungeonStrings {
        public final String category;
        public final String unlocName;

        public JERDungeonStrings(ResourceLocation lootTable) {
            this.category = lootTable.toString();
            this.unlocName = StringHelper.getDungeonTranslationKey(lootTable);
        }
    }
}

