/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigHarvestcraft;
import com.invadermonky.justenoughmagiculture.integrations.jei.categories.jer.plant.CustomPlantEntry;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.pam.harvestcraft.HarvestCraft;
import com.pam.harvestcraft.blocks.BlockRegistry;
import com.pam.harvestcraft.blocks.CropRegistry;
import com.pam.harvestcraft.blocks.FruitRegistry;
import com.pam.harvestcraft.blocks.blocks.BlockBaseGarden;
import com.pam.harvestcraft.blocks.growables.BlockPamCrop;
import com.pam.harvestcraft.blocks.growables.BlockPamFruit;
import com.pam.harvestcraft.blocks.growables.BlockPamFruitLog;
import java.util.ArrayList;
import java.util.List;
import jeresources.api.drop.PlantDrop;
import jeresources.entry.PlantEntry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.IPlantable;

public class JERHarvestcraft
extends JERBase
implements IJERIntegration {
    private final JEMConfigHarvestcraft.JER jerConfig;
    private static JERHarvestcraft instance;

    private JERHarvestcraft() {
        this.jerConfig = JEMConfig.HARVESTCRAFT.JUST_ENOUGH_RESOURCES;
    }

    public JERHarvestcraft(boolean enableJERPlants) {
        this.jerConfig = JEMConfig.HARVESTCRAFT.JUST_ENOUGH_RESOURCES;
        if (enableJERPlants) {
            this.registerModPlants();
        }
        JERHarvestcraft.getInstance();
    }

    public static JERHarvestcraft getInstance() {
        return instance == null ? (instance = new JERHarvestcraft()) : instance;
    }

    @Override
    public void registerModPlants() {
        if (this.jerConfig.enableCrops) {
            this.registerHCCrops();
        }
        if (this.jerConfig.enableFruit) {
            this.registerHCFruit();
        }
        if (this.jerConfig.enableGardens) {
            this.registerHCGardens();
        }
        if (this.jerConfig.enableHarvestLogs) {
            this.registerHCHarvestLogs();
        }
    }

    private void registerHCCrops() {
        for (BlockPamCrop crop : CropRegistry.getCrops().values()) {
            Item food;
            Item seeds = crop.func_149866_i();
            PlantDrop[] drops = seeds == (food = crop.func_149865_P()) ? new PlantDrop[]{new PlantDrop(new ItemStack(seeds), 1, 4)} : new PlantDrop[]{new PlantDrop(new ItemStack(seeds), 1, 1), new PlantDrop(new ItemStack(food), 0, 2)};
            if (seeds instanceof IPlantable) {
                this.registerPlant((Item)((IPlantable)seeds), drops);
                continue;
            }
            this.registerPlant(new ItemStack(seeds), drops);
        }
    }

    private void registerHCFruit() {
        for (BlockPamFruit fruit : FruitRegistry.fruits) {
            CustomPlantEntry entry = new CustomPlantEntry(new ItemStack((Block)fruit.getSapling()), fruit.func_176223_P(), new PlantDrop(new ItemStack(fruit.getFruitItem()), 1, 1));
            entry.setSoil(Blocks.field_150350_a.func_176223_P());
            this.registerCustomPlant(entry);
        }
    }

    private void registerHCGardens() {
        BlockRegistry.gardens.forEach((name, garden) -> {
            ArrayList<PlantDrop> plantDrops = new ArrayList<PlantDrop>();
            int totalDrops = ((List)BlockBaseGarden.drops.get(name)).size();
            float chance = (float)Math.min(HarvestCraft.config.gardendropAmount, totalDrops) / (float)totalDrops;
            for (ItemStack stack : (List)BlockBaseGarden.drops.get(name)) {
                plantDrops.add(new PlantDrop(stack, chance));
            }
            PlantEntry plantEntry = new PlantEntry(new ItemStack((Block)garden, 1, 0), plantDrops.toArray(new PlantDrop[0]));
            if (name.equals("aridGarden")) {
                plantEntry.setSoil(Blocks.field_150354_m.func_176223_P());
            } else {
                plantEntry.setSoil(Blocks.field_150349_c.func_176223_P());
            }
            this.registerCustomPlant(plantEntry);
        });
    }

    private void registerHCHarvestLogs() {
        for (BlockPamFruitLog log : FruitRegistry.logs.values()) {
            CustomPlantEntry entry = new CustomPlantEntry(new ItemStack((Block)log.getSapling()), log.func_176223_P(), new PlantDrop(new ItemStack(log.getFruitItem()), 1, 1));
            entry.setSoil(log.func_176223_P());
            this.registerCustomPlant(entry);
        }
    }
}

