/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigFamiliarFauna;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.util.BiomeHelper;
import familiarfauna.config.ConfigurationHandler;
import familiarfauna.entities.EntityButterfly;
import familiarfauna.entities.EntityDeer;
import familiarfauna.entities.EntityDragonfly;
import familiarfauna.entities.EntityPixie;
import familiarfauna.entities.EntitySnail;
import familiarfauna.entities.EntityTurkey;
import familiarfauna.init.ModConfiguration;
import familiarfauna.init.ModLootTable;
import jeresources.api.conditionals.LightLevel;
import net.minecraft.entity.EntityLivingBase;

public class JERFamiliarFauna
extends JERBase
implements IJERIntegration {
    private final JEMConfigFamiliarFauna.JER jerConfig;

    public JERFamiliarFauna(boolean enableJERMobs) {
        this.jerConfig = JEMConfig.FAMILIAR_FAUNA.JUST_ENOUGH_RESOURCES;
        if (enableJERMobs) {
            this.registerModEntities();
        }
    }

    @Override
    public void registerModEntities() {
        if (this.jerConfig.enableButterfly && ConfigurationHandler.butterflyEnable) {
            this.registerMob((EntityLivingBase)new EntityButterfly(this.world), LightLevel.any, 0, 1, BiomeHelper.getBiomeNamesForBiomes(ModConfiguration.butterflyBiomeList.toArray(new String[0])), ModLootTable.BUTTERFLY_LOOT);
        }
        if (this.jerConfig.enableDeer && ConfigurationHandler.deerEnable) {
            this.registerMob((EntityLivingBase)new EntityDeer(this.world), LightLevel.any, 1, 3, BiomeHelper.getBiomeNamesForBiomes(ModConfiguration.deerBiomeList.toArray(new String[0])), ModLootTable.DEER_LOOT);
        }
        if (this.jerConfig.enableDragonfly && ConfigurationHandler.dragonflyEnable) {
            this.registerMob((EntityLivingBase)new EntityDragonfly(this.world), LightLevel.any, 0, 1, BiomeHelper.getBiomeNamesForBiomes(ModConfiguration.dragonflyBiomeList.toArray(new String[0])), ModLootTable.DRAGONFLY_LOOT);
        }
        if (this.jerConfig.enablePixie && ConfigurationHandler.pixieEnable) {
            this.registerMob((EntityLivingBase)new EntityPixie(this.world), LightLevel.any, 0, 1, BiomeHelper.getBiomeNamesForBiomes(ModConfiguration.pixieBiomeList.toArray(new String[0])), ModLootTable.PIXIE_LOOT);
        }
        if (this.jerConfig.enableSnail && ConfigurationHandler.snailEnable) {
            this.registerMob((EntityLivingBase)new EntitySnail(this.world), LightLevel.any, 0, 1, BiomeHelper.getBiomeNamesForBiomes(ModConfiguration.snailBiomeList.toArray(new String[0])), ModLootTable.SNAIL_LOOT);
        }
        if (this.jerConfig.enableTurkey && ConfigurationHandler.turkeyEnable) {
            this.registerMob((EntityLivingBase)new EntityTurkey(this.world), LightLevel.any, 1, 3, BiomeHelper.getBiomeNamesForBiomes(ModConfiguration.turkeyBiomeList.toArray(new String[0])), ModLootTable.TURKEY_LOOT);
        }
    }
}

