/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigCharm;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.integrations.jer.conditionals.JEMLightLevel;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import com.invadermonky.justenoughmagiculture.util.Reference;
import com.invadermonky.justenoughmagiculture.util.StringHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Set;
import jeresources.api.conditionals.Conditional;
import jeresources.api.drop.LootDrop;
import jeresources.entry.MobEntry;
import jeresources.registry.MobRegistry;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import svenhjol.charm.Charm;
import svenhjol.charm.brewing.potion.DecayPotion;
import svenhjol.charm.tweaks.feature.WitchesDropDecay;
import svenhjol.charm.tweaks.feature.WitchesDropLuck;
import svenhjol.charm.world.entity.EntitySpectre;
import svenhjol.charm.world.feature.AbandonedCrates;
import svenhjol.charm.world.feature.Spectre;
import svenhjol.charm.world.feature.SwampHutDecorations;
import svenhjol.charm.world.feature.VillageDecorations;

public class JERCharm
extends JERBase
implements IJERIntegration {
    private static final JEMConfigCharm.JER jerConfig = JEMConfig.CHARM.JUST_ENOUGH_RESOURCES;
    private static JERCharm instance;

    private JERCharm() {
    }

    public JERCharm(boolean enableJERDungeons, boolean enableJERMobs) {
        if (enableJERDungeons) {
            this.registerModDungeons();
        }
        if (enableJERMobs) {
            this.registerModEntities();
        }
        JERCharm.getInstance();
    }

    public static JERCharm getInstance() {
        return instance == null ? (instance = new JERCharm()) : instance;
    }

    @Override
    public void registerModDungeons() {
        if (Charm.hasFeature(AbandonedCrates.class) && AbandonedCrates.generateChance > 0.0) {
            JERDungeonStrings crate = new JERDungeonStrings("abandoned_crate", false);
            this.registerDungeonLoot(crate.category, crate.unlocName, Reference.FakeTables.CHARM_CRATE_FAKE_TABLE);
        }
        if (Charm.hasFeature(SwampHutDecorations.class)) {
            this.registerCharmDungeonLoot("common_potions", false);
        }
        if (Charm.hasFeature(VillageDecorations.class) && VillageDecorations.storage) {
            this.registerCharmDungeonLoot("butcher", true);
            this.registerCharmDungeonLoot("carpenter", true);
            this.registerCharmDungeonLoot("farmer", true);
            this.registerCharmDungeonLoot("fisherman", true);
            this.registerCharmDungeonLoot("librarian", true);
            this.registerCharmDungeonLoot("priest", true);
            this.registerCharmDungeonLoot("shepherd", true);
            this.registerCharmDungeonLoot("smith", true);
        }
    }

    @Override
    public void registerModEntities() {
        if (Charm.hasFeature(Spectre.class) && JERCharm.jerConfig.enableSpectre) {
            this.registerMob((EntityLivingBase)new EntitySpectre(this.world), JEMLightLevel.custom(Spectre.despawnLight, false), EntitySpectre.LOOT_TABLE);
            this.registerRenderHook(EntitySpectre.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)-0.05, (double)-0.4, (double)0.0);
                return renderInfo;
            });
        }
    }

    @Override
    public void injectLoot() {
        if (JEMConfig.CHARM.enableJERInjectedLoot) {
            for (MobEntry mobEntry : MobRegistry.getInstance().getMobs()) {
                if (!(mobEntry.getEntity() instanceof EntityWitch)) continue;
                try {
                    ItemStack potion;
                    Field entryField = MobRegistry.getInstance().getClass().getDeclaredField("registry");
                    entryField.setAccessible(true);
                    Set mobEntries = (Set)entryField.get(MobRegistry.getInstance());
                    mobEntries.remove(mobEntry);
                    ArrayList<LootDrop> dropsToAdd = new ArrayList<LootDrop>();
                    if (Charm.hasFeature(WitchesDropDecay.class) && WitchesDropDecay.dropChance > 0.0) {
                        potion = new ItemStack((Item)Items.field_151068_bn);
                        PotionUtils.func_185188_a((ItemStack)potion, (PotionType)DecayPotion.type);
                        LootDrop decayDrop = new LootDrop(potion, 0, 1, (float)WitchesDropDecay.dropChance, new Conditional[]{Conditional.affectedByLooting});
                        dropsToAdd.add(decayDrop);
                    }
                    if (Charm.hasFeature(WitchesDropLuck.class) && WitchesDropLuck.dropChance > 0.0) {
                        potion = new ItemStack((Item)Items.field_151068_bn);
                        PotionUtils.func_185188_a((ItemStack)potion, (PotionType)((PotionType)PotionType.field_185176_a.func_82594_a((Object)new ResourceLocation("luck"))));
                        LootDrop luckDrop = new LootDrop(potion, 0, 1, (float)WitchesDropLuck.dropChance, new Conditional[]{Conditional.affectedByLooting});
                        dropsToAdd.add(luckDrop);
                    }
                    mobEntry.addDrops(dropsToAdd.toArray(new LootDrop[0]));
                    mobEntries.add(mobEntry);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void registerCharmDungeonLoot(String name, boolean isVillage) {
        JERDungeonStrings dungeon = new JERDungeonStrings(name, isVillage);
        this.registerDungeonLoot(dungeon.category, dungeon.unlocName, dungeon.lootTable);
    }

    private static class JERDungeonStrings {
        public final String category;
        public final String unlocName;
        public final ResourceLocation lootTable;

        public JERDungeonStrings(String dungeon, boolean isVillage) {
            this.category = isVillage ? String.format("%s:%s/%s", ModIds.CHARM.MOD_ID, "village", dungeon) : String.format("%s:%s/%s", ModIds.CHARM.MOD_ID, "treasure", dungeon);
            this.unlocName = StringHelper.getDungeonTranslationKey(ModIds.CHARM.MOD_ID, dungeon);
            this.lootTable = new ResourceLocation(this.category);
        }
    }
}

