/*
 * Decompiled with CFR 0.152.
 */
package com.invadermonky.justenoughmagiculture.integrations.jer.mods;

import com.invadermonky.justenoughmagiculture.configs.JEMConfig;
import com.invadermonky.justenoughmagiculture.configs.mods.JEMConfigBeastSlayer;
import com.invadermonky.justenoughmagiculture.integrations.jer.IJERIntegration;
import com.invadermonky.justenoughmagiculture.integrations.jer.JERBase;
import com.invadermonky.justenoughmagiculture.util.BiomeHelper;
import com.invadermonky.justenoughmagiculture.util.ModIds;
import com.invadermonky.justenoughmagiculture.util.StringHelper;
import com.unoriginal.ancientbeasts.config.AncientBeastsConfig;
import com.unoriginal.ancientbeasts.entity.Entities.EntityBonepile;
import com.unoriginal.ancientbeasts.entity.Entities.EntityBoulderer;
import com.unoriginal.ancientbeasts.entity.Entities.EntityDamcell;
import com.unoriginal.ancientbeasts.entity.Entities.EntityFrostWalker;
import com.unoriginal.ancientbeasts.entity.Entities.EntityGhost;
import com.unoriginal.ancientbeasts.entity.Entities.EntityGiant;
import com.unoriginal.ancientbeasts.entity.Entities.EntityNekros;
import com.unoriginal.ancientbeasts.entity.Entities.EntityNetherhound;
import com.unoriginal.ancientbeasts.entity.Entities.EntityOwlstack;
import com.unoriginal.ancientbeasts.entity.Entities.EntityRiftedEnderman;
import com.unoriginal.ancientbeasts.entity.Entities.EntitySandy;
import com.unoriginal.ancientbeasts.entity.Entities.EntityVessel;
import com.unoriginal.ancientbeasts.entity.Entities.EntityZealot;
import jeresources.api.conditionals.LightLevel;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.BiomeDictionary;

public class JERBeastSlayer
extends JERBase
implements IJERIntegration {
    JEMConfigBeastSlayer.JER jerConfig;

    public JERBeastSlayer(boolean enableJERDungeons, boolean enableJERMobs) {
        this.jerConfig = JEMConfig.BEAST_SLAYER.JUST_ENOUGH_RESOURCES;
        if (enableJERDungeons) {
            this.registerModDungeons();
        }
        if (enableJERMobs) {
            this.registerModEntities();
        }
    }

    @Override
    public void registerModDungeons() {
        ResourceLocation lootTable = new ResourceLocation(ModIds.BEAST_SLAYER.MOD_ID, "structures/circus");
        this.registerDungeonLoot(lootTable.toString(), StringHelper.getDungeonTranslationKey(ModIds.BEAST_SLAYER.MOD_ID, "circus"), lootTable);
    }

    @Override
    public void registerModEntities() {
        if (this.jerConfig.enableBonepile && AncientBeastsConfig.bonepileSpawnChance > 0) {
            this.registerMob((EntityLivingBase)new EntityBonepile(this.world), LightLevel.hostile, EntityBonepile.LOOT);
            this.registerRenderHook(EntityBonepile.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.3, (double)1.3, (double)1.3);
                return renderInfo;
            });
        }
        if (this.jerConfig.enableBoulderingZombie) {
            this.registerMob((EntityLivingBase)new EntityBoulderer(this.world), LightLevel.hostile, LootTableList.field_186383_ah);
        }
        if (this.jerConfig.enableDamcell && AncientBeastsConfig.damcellSpawnChance > 0) {
            this.registerMob((EntityLivingBase)new EntityDamcell(this.world), LightLevel.hostile, EntityDamcell.LOOT);
            this.registerRenderHook(EntityDamcell.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)-0.05, (double)-0.8, (double)0.0);
                GlStateManager.func_179139_a((double)1.2, (double)1.2, (double)1.2);
                return renderInfo;
            });
        }
        if (this.jerConfig.enableFrostwalker) {
            this.registerMob((EntityLivingBase)new EntityFrostWalker(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForTypes(BiomeDictionary.Type.SNOWY), LootTableList.field_186383_ah);
            this.registerRenderHook(EntityFrostWalker.class, (renderInfo, e) -> {
                GlStateManager.func_179139_a((double)1.3, (double)1.3, (double)1.3);
                GlStateManager.func_179137_b((double)0.1, (double)0.0, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.enableGhost) {
            this.registerMob((EntityLivingBase)new EntityGhost(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForTypes(BiomeDictionary.Type.SPOOKY), EntityGhost.LOOT);
            this.adjustHumanoidRenderHook(EntityGhost.class);
        }
        if (this.jerConfig.enableGiant) {
            this.registerMob((EntityLivingBase)new EntityGiant(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76772_c, Biomes.field_185441_Q), EntityGiant.LOOT);
            this.registerRenderHook(EntityGiant.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)-0.1, (double)-1.5, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.enableNekros) {
            this.registerMob((EntityLivingBase)new EntityNekros(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForTypes(BiomeDictionary.Type.SPOOKY), EntityNekros.LOOT);
            this.adjustHumanoidRenderHook(EntityNekros.class);
        }
        if (this.jerConfig.enableNetherhound) {
            this.registerMob((EntityLivingBase)new EntityNetherhound(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForTypes(BiomeDictionary.Type.NETHER), EntityNetherhound.LOOT);
        }
        if (this.jerConfig.enableOwlstack) {
            this.registerMob((EntityLivingBase)new EntityOwlstack(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_150583_P, Biomes.field_150582_Q, Biomes.field_185448_Z, Biomes.field_185429_aa), EntityOwlstack.LOOT);
            this.registerRenderHook(EntityOwlstack.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)-0.05, (double)0.15, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.enableRiftedEnderman) {
            this.registerMob((EntityLivingBase)new EntityRiftedEnderman(this.world), LightLevel.hostile, EntityRiftedEnderman.LOOT);
            this.adjustHumanoidRenderHook(EntityRiftedEnderman.class);
        }
        if (this.jerConfig.enableSandMonster && AncientBeastsConfig.isSandmonsterEnabled) {
            this.registerMob((EntityLivingBase)new EntitySandy(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_76769_d, Biomes.field_76786_s), EntitySandy.LOOT);
            this.registerRenderHook(EntitySandy.class, (renderInfo, e) -> {
                GlStateManager.func_179137_b((double)-0.08, (double)0.3, (double)0.0);
                return renderInfo;
            });
        }
        if (this.jerConfig.enableVessel) {
            this.registerMob((EntityLivingBase)new EntityVessel(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForBiomes(Biomes.field_150585_R, Biomes.field_185430_ab), EntityVessel.LOOT);
        }
        if (this.jerConfig.enableZealot) {
            if (AncientBeastsConfig.zealotSpawnEverywhere) {
                this.registerMob((EntityLivingBase)new EntityZealot(this.world), LightLevel.hostile, EntityZealot.LOOT);
            } else {
                this.registerMob((EntityLivingBase)new EntityZealot(this.world), LightLevel.hostile, BiomeHelper.getBiomeNamesForTypes(BiomeDictionary.Type.SPOOKY), EntityZealot.LOOT);
            }
            this.adjustHumanoidRenderHook(EntityZealot.class);
        }
    }

    private void adjustHumanoidRenderHook(Class<? extends EntityLiving> clazz) {
        this.registerRenderHook(clazz, (renderInfo, e) -> {
            GlStateManager.func_179137_b((double)-0.05, (double)-0.45, (double)0.0);
            return renderInfo;
        });
    }
}

