/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.genetics.fruits;

import binnie.extratrees.genetics.fruits.ETFruitProviderNone;
import binnie.extratrees.genetics.fruits.FruitPod;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IFruitFamily;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ETFruitProviderPod
extends ETFruitProviderNone {
    @Nullable
    private final FruitPod pod;

    public ETFruitProviderPod(String name, IFruitFamily family, FruitPod pod) {
        super(name, family);
        this.pod = pod;
    }

    @Override
    public boolean trySpawnFruitBlock(ITreeGenome genome, World world, Random rand, BlockPos pos) {
        if (rand.nextFloat() > genome.getSappiness()) {
            return false;
        }
        IAlleleFruit activeAllele = (IAlleleFruit)genome.getActiveAllele((IChromosomeType)EnumTreeChromosome.FRUITS);
        return TreeManager.treeRoot.setFruitBlock(world, genome, activeAllele, genome.getYield(), pos);
    }

    @Override
    public NonNullList<ItemStack> getFruits(ITreeGenome genome, World world, BlockPos pos, int ripeningTime) {
        NonNullList products = NonNullList.func_191196_a();
        if (this.pod != null && ripeningTime >= 2) {
            for (Map.Entry product : this.products.entrySet()) {
                ItemStack single = ((ItemStack)product.getKey()).func_77946_l();
                single.func_190920_e(1);
                for (int i = 0; i < ((ItemStack)product.getKey()).func_190916_E(); ++i) {
                    if (!(world.field_73012_v.nextFloat() <= ((Float)product.getValue()).floatValue())) continue;
                    products.add((Object)single.func_77946_l());
                }
            }
        }
        return products;
    }

    @Override
    public boolean requiresFruitBlocks() {
        return true;
    }

    @Override
    @Nullable
    public String getModelName() {
        if (this.pod != null) {
            return this.pod.getModelName();
        }
        return null;
    }
}

