/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.prefab.items;

import cofh.redstoneflux.api.IEnergyContainerItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import javax.annotation.Nullable;
import mekanism.api.energy.IEnergizedItem;
import micdoodle8.mods.galacticraft.api.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.api.item.IItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.energy.item.ElectricItemManagerIC2;
import micdoodle8.mods.galacticraft.core.items.ItemBatteryInfinite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(modid="redstoneflux", iface="cofh.redstoneflux.api.IEnergyContainerItem"), @Optional.Interface(modid="mekanism", iface="mekanism.api.energy.IEnergizedItem"), @Optional.Interface(modid="ic2", iface="ic2.api.item.IElectricItem"), @Optional.Interface(modid="ic2", iface="ic2.api.item.ISpecialElectricItem")})
public class ItemElectricPickaxe
extends ItemPickaxe
implements IEnergyContainerItem,
IElectricItem,
ISpecialElectricItem,
IEnergizedItem,
IItemElectricBase {
    private static Object itemManagerIC2;
    public float transferMax;
    private static final int DAMAGE_RANGE = 100;
    private final float maxCapacity;

    protected ItemElectricPickaxe(Item.ToolMaterial material, float max_capacity) {
        super(material);
        this.func_77656_e(100);
        this.setNoRepair();
        this.setMaxTransfer();
        this.maxCapacity = max_capacity;
        if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
            itemManagerIC2 = new ElectricItemManagerIC2();
        }
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String color = "";
        float joules = this.getElectricityStored(itemStack);
        color = joules <= this.getMaxElectricityStored(itemStack) / 3.0f ? "\u00a74" : (joules > this.getMaxElectricityStored(itemStack) * 2.0f / 3.0f ? "\u00a72" : "\u00a76");
        tooltip.add(color + EnergyDisplayHelper.getEnergyDisplayS((float)joules) + "/" + EnergyDisplayHelper.getEnergyDisplayS((float)this.getMaxElectricityStored(itemStack)));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == this.func_77640_w() || tab == CreativeTabs.field_78027_g) {
            list.add((Object)ElectricItemHelper.getUncharged((ItemStack)new ItemStack((Item)this)));
            list.add((Object)ElectricItemHelper.getWithCharge((ItemStack)new ItemStack((Item)this), (float)this.getMaxElectricityStored(new ItemStack((Item)this))));
        }
    }

    protected void setMaxTransfer() {
        this.transferMax = 2000.0f;
    }

    public void func_77622_d(ItemStack itemStack, World par2World, EntityPlayer par3EntityPlayer) {
        this.setElectricity(itemStack, 0.0f);
    }

    public float recharge(ItemStack itemStack, float energy, boolean doReceive) {
        float rejectedElectricity = Math.max(this.getElectricityStored(itemStack) + energy - this.getMaxElectricityStored(itemStack), 0.0f);
        float energyToReceive = energy - rejectedElectricity;
        if (energyToReceive > this.transferMax) {
            rejectedElectricity += energyToReceive - this.transferMax;
            energyToReceive = this.transferMax;
        }
        if (doReceive) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) + energyToReceive);
        }
        return energyToReceive;
    }

    public float discharge(ItemStack itemStack, float energy, boolean doTransfer) {
        float thisEnergy = this.getElectricityStored(itemStack);
        float energyToTransfer = Math.min(Math.min(thisEnergy, energy), this.transferMax);
        if (doTransfer) {
            this.setElectricity(itemStack, thisEnergy - energyToTransfer);
        }
        return energyToTransfer;
    }

    public float getElectricityStored(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        float energyStored = 0.0f;
        if (stack.func_77978_p().func_74764_b("electricity")) {
            NBTBase obj = stack.func_77978_p().func_74781_a("electricity");
            if (obj instanceof NBTTagDouble) {
                energyStored = ((NBTTagDouble)obj).func_150288_h();
            } else if (obj instanceof NBTTagFloat) {
                energyStored = ((NBTTagFloat)obj).func_150288_h();
            }
        }
        stack.func_77964_b((int)((float)stack.func_77958_k() - energyStored / this.getMaxElectricityStored(stack) * (float)stack.func_77958_k()));
        return energyStored;
    }

    public float getMaxElectricityStored(ItemStack theItem) {
        return this.maxCapacity;
    }

    public void setElectricity(ItemStack stack, float joules) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        float electricityStored = Math.max(Math.min(joules, this.getMaxElectricityStored(stack)), 0.0f);
        stack.func_77978_p().func_74776_a("electricity", electricityStored);
        stack.func_77964_b((int)((float)stack.func_77958_k() - electricityStored / this.getMaxElectricityStored(stack) * (float)stack.func_77958_k()));
    }

    public float getTransfer(ItemStack itemStack) {
        return Math.min(this.transferMax, this.getMaxElectricityStored(itemStack) - this.getElectricityStored(itemStack));
    }

    public int getTierGC(ItemStack itemStack) {
        return 1;
    }

    public float getMaxTransferGC(ItemStack itemStack) {
        return this.transferMax;
    }

    public static boolean isElectricItem(Item item) {
        if (item instanceof IItemElectricBase) {
            return true;
        }
        return EnergyConfigHandler.isIndustrialCraft2Loaded() && item instanceof ISpecialElectricItem;
    }

    public static boolean isElectricItemEmpty(ItemStack itemstack) {
        if (itemstack.func_190926_b()) {
            return false;
        }
        Item item = itemstack.func_77973_b();
        if (item instanceof IItemElectricBase) {
            return ((IItemElectricBase)item).getElectricityStored(itemstack) <= 0.0f;
        }
        if (EnergyConfigHandler.isIndustrialCraft2Loaded() && item instanceof IElectricItem) {
            return !((IElectricItem)item).canProvideEnergy(itemstack);
        }
        return false;
    }

    public static boolean isElectricItemCharged(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        Item item = itemstack.func_77973_b();
        if (item instanceof IItemElectricBase) {
            return ((IItemElectricBase)item).getElectricityStored(itemstack) > 0.0f;
        }
        if (EnergyConfigHandler.isIndustrialCraft2Loaded() && item instanceof IElectricItem) {
            return ((IElectricItem)item).canProvideEnergy(itemstack);
        }
        return false;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return (int)(this.recharge(container, (float)maxReceive * EnergyConfigHandler.RF_RATIO, !simulate) / EnergyConfigHandler.RF_RATIO);
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return (int)(this.discharge(container, (float)maxExtract / EnergyConfigHandler.TO_RF_RATIO, !simulate) * EnergyConfigHandler.TO_RF_RATIO);
    }

    public int getEnergyStored(ItemStack container) {
        return (int)(this.getElectricityStored(container) * EnergyConfigHandler.TO_RF_RATIO);
    }

    public int getMaxEnergyStored(ItemStack container) {
        return (int)(this.getMaxElectricityStored(container) * EnergyConfigHandler.TO_RF_RATIO);
    }

    public double getEnergy(ItemStack itemStack) {
        return this.getElectricityStored(itemStack) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    public void setEnergy(ItemStack itemStack, double amount) {
        this.setElectricity(itemStack, (float)amount * EnergyConfigHandler.MEKANISM_RATIO);
    }

    public double getMaxEnergy(ItemStack itemStack) {
        return this.getMaxElectricityStored(itemStack) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    public double getMaxTransfer(ItemStack itemStack) {
        return this.transferMax * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    public boolean canReceive(ItemStack itemStack) {
        return itemStack != null && !(itemStack.func_77973_b() instanceof ItemBatteryInfinite);
    }

    public boolean canSend(ItemStack itemStack) {
        return true;
    }

    public IElectricItemManager getManager(ItemStack itemstack) {
        return (IElectricItemManager)itemManagerIC2;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public int getTier(ItemStack itemStack) {
        return 1;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return this.getMaxElectricityStored(itemStack) / EnergyConfigHandler.IC2_RATIO;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return this.transferMax * EnergyConfigHandler.TO_IC2_RATIO;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyCapabilityProvider(stack, this);
    }

    private class EnergyCapabilityProvider
    implements ICapabilityProvider {
        EnergyStorage storage;

        public EnergyCapabilityProvider(final ItemStack stack, final ItemElectricPickaxe item) {
            this.storage = new EnergyStorage((int)(item.getMaxElectricityStored(stack) * EnergyConfigHandler.TO_RF_RATIO), (int)item.transferMax){

                public int receiveEnergy(int maxReceive, boolean simulate) {
                    if (!this.canReceive()) {
                        return 0;
                    }
                    return (int)(item.recharge(stack, (float)maxReceive * EnergyConfigHandler.RF_RATIO, !simulate) / EnergyConfigHandler.RF_RATIO);
                }

                public int extractEnergy(int maxExtract, boolean simulate) {
                    if (!this.canExtract()) {
                        return 0;
                    }
                    return (int)(item.discharge(stack, (float)this.maxReceive / EnergyConfigHandler.RF_RATIO, !simulate) * EnergyConfigHandler.RF_RATIO);
                }

                public int getEnergyStored() {
                    return (int)(item.getMaxElectricityStored(stack) * EnergyConfigHandler.TO_RF_RATIO);
                }
            };
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityEnergy.ENERGY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (this.hasCapability(capability, facing)) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)this.storage);
            }
            return null;
        }
    }
}

