/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy.dimension.world.data;

import asmodeuscore.api.dimension.IProviderWeather;
import asmodeuscore.core.astronomy.WeatherData;
import asmodeuscore.core.prefab.entities.EntityAdvMeteor;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class MeteoricRainSaveData
extends WorldSavedData {
    public int tickMeteoricRain = 0;
    public int tickClearWeather = 120000;

    public MeteoricRainSaveData(String name) {
        super(name);
    }

    public static MeteoricRainSaveData get(World world, String name) {
        name = name + "_meteoricrain";
        MapStorage storage = world.getPerWorldStorage();
        MeteoricRainSaveData instance = (MeteoricRainSaveData)storage.func_75742_a(MeteoricRainSaveData.class, name);
        if (instance == null) {
            instance = new MeteoricRainSaveData(name);
            storage.func_75745_a(name, (WorldSavedData)instance);
        }
        return instance;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.tickMeteoricRain = nbt.func_74762_e("tickMeteoricRain");
        this.tickClearWeather = nbt.func_74762_e("tickClearWeather");
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74768_a("tickMeteoricRain", this.tickMeteoricRain);
        compound.func_74768_a("tickClearWeather", this.tickClearWeather);
        return compound;
    }

    public boolean isMeteoricStorm() {
        return this.tickMeteoricRain > 0;
    }

    public static void calculateWeather(MeteoricRainSaveData data, Random rand) {
        int meteoricRain;
        if (!data.isMeteoricStorm()) {
            int clearWeather;
            if ((clearWeather = data.tickClearWeather--) >= 0 && clearWeather <= 0) {
                data.tickMeteoricRain = rand.nextInt(6000) + 6000;
            }
        } else if ((meteoricRain = data.tickMeteoricRain--) >= 0 && meteoricRain <= 0) {
            data.tickClearWeather = rand.nextInt(168000) + 12000;
        }
        data.func_76185_a();
    }

    public static void spawnMeteor(MeteoricRainSaveData data) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (!data.isMeteoricStorm()) {
            return;
        }
        for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
            MeteoricRainSaveData.throwMeteors(player, 12, 3);
        }
    }

    private static void throwMeteors(EntityPlayerMP player, int freq, int chanceSpawnBlock) {
        EntityPlayer closestPlayer;
        World world = player.field_70170_p;
        if (world.field_73011_w instanceof IProviderWeather && !world.field_72995_K && ((IProviderWeather)world.field_73011_w).getWeather().getWeatherType() == WeatherData.WeatherType.METEORIC_RAIN && world.field_73012_v.nextInt(freq) == 0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
            int x = world.field_73012_v.nextInt(60) - 30;
            int y = world.field_73012_v.nextInt(20) + 200;
            int z = world.field_73012_v.nextInt(60) - 30;
            double motX = world.field_73012_v.nextDouble() * 1.0;
            double motZ = world.field_73012_v.nextDouble() * 1.0;
            IBlockState block = null;
            if (chanceSpawnBlock > 0) {
                block = world.field_73012_v.nextInt(100) <= chanceSpawnBlock ? GCBlocks.fallenMeteor.func_176223_P() : null;
            }
            EntityAdvMeteor meteor = new EntityAdvMeteor(world, player.field_70165_t + (double)x, player.field_70163_u + (double)y, player.field_70161_v + (double)z, motX - 0.5, 0.0, motZ - 0.5, world.field_73012_v.nextInt(3)).setSpawnBlock(block);
            world.func_72838_d((Entity)meteor);
        }
    }
}

