/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy;

import asmodeuscore.api.dimension.IAdvancedSpace;
import javax.annotation.Nullable;

public class BodiesData {
    private IAdvancedSpace.TypeBody type;
    private IAdvancedSpace.ClassBody classbody;
    private IAdvancedSpace.StarColor starcolor;
    private IAdvancedSpace.StarType startype;
    private float habitableDistance = 0.0f;
    private float habitableSize = 0.0f;
    private int pressure = 0;
    private boolean solarradiation = false;

    public BodiesData(IAdvancedSpace.TypeBody type) {
        this(type, null, 0, false);
    }

    public BodiesData(IAdvancedSpace.TypeBody type, IAdvancedSpace.ClassBody classPlanet) {
        this(type, classPlanet, 0, false);
    }

    public BodiesData(@Nullable IAdvancedSpace.ClassBody classPlanet, int pressure, boolean solarrad) {
        this(null, classPlanet, pressure, solarrad);
    }

    public BodiesData(@Nullable IAdvancedSpace.TypeBody type, @Nullable IAdvancedSpace.ClassBody classPlanet, int pressure, boolean solarrad) {
        this.type = type;
        this.classbody = classPlanet;
        this.pressure = pressure;
        this.solarradiation = solarrad;
    }

    public BodiesData setStarColor(@Nullable IAdvancedSpace.StarColor color) {
        this.starcolor = color;
        return this;
    }

    @Deprecated
    public BodiesData setStarClass(IAdvancedSpace.StarClass starclass) {
        this.startype = IAdvancedSpace.StarType.valueOf(starclass.name());
        return this;
    }

    public BodiesData setStarType(IAdvancedSpace.StarType starclass) {
        this.startype = starclass;
        return this;
    }

    public BodiesData setStarHabitableZone(float distance, float size) {
        this.habitableDistance = distance;
        this.habitableSize = size;
        return this;
    }

    public int getPressure() {
        return this.pressure;
    }

    public boolean isSolarRadiation() {
        return this.solarradiation;
    }

    public IAdvancedSpace.StarColor getStarColor() {
        return this.starcolor;
    }

    public IAdvancedSpace.TypeBody getType() {
        return this.type;
    }

    public IAdvancedSpace.ClassBody getPlanetClass() {
        return this.classbody;
    }

    public IAdvancedSpace.StarType getStarType() {
        return this.startype;
    }

    public float getStarHZoneDistance() {
        return this.habitableDistance;
    }

    public float getStarHZoneSize() {
        return this.habitableSize;
    }

    public String toString() {
        if (this.getType() != null) {
            if (this.getType().equals((Object)IAdvancedSpace.TypeBody.STAR)) {
                return "{ Type:" + this.getType().name() + ", StarClass: " + (Object)((Object)this.getStarType()) + ", StarColor: " + (Object)((Object)this.getStarColor()) + "}";
            }
            if (this.getPlanetClass() != null) {
                return "{ Type:" + this.getType().name() + ", PlanetClass: " + this.getPlanetClass().name() + ", Pressure: " + this.getPressure() + ", SolarRad: " + this.isSolarRadiation() + "}";
            }
            return "{ Type:" + this.getType().name() + ", Pressure: " + this.getPressure() + ", SolarRad: " + this.isSolarRadiation() + "}";
        }
        return super.toString();
    }
}

