/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.realtimers;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.ILeverModule;
import vswe.stevescarts.modules.ModuleBase;
import vswe.stevescarts.modules.engines.ModuleEngine;
import vswe.stevescarts.packet.PacketStevesCarts;

public class ModuleAdvControl
extends ModuleBase
implements ILeverModule {
    private byte[] engineInformation;
    private int tripPacketTimer;
    private int enginePacketTimer;
    private byte keyinformation;
    private double lastPosX;
    private double lastPosY;
    private double lastPosZ;
    private boolean first = true;
    private int speedChangeCooldown;
    private boolean lastBackKey;
    private double odo;
    private double trip;
    private int[] buttonRect = new int[]{15, 20, 24, 12};
    private DataParameter<Integer> SPEED;

    public ModuleAdvControl(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 90;
    }

    @Override
    public int guiHeight() {
        return 35;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderOverlay(Minecraft minecraft) {
        ResourceHelper.bindResource("/gui/drive.png");
        if (this.engineInformation != null) {
            for (int i = 0; i < this.getCart().getEngines().size(); ++i) {
                this.drawImage(5, i * 15, 0, 0, 66, 15);
                int upperBarLength = this.engineInformation[i * 2] & 0x3F;
                int lowerBarLength = this.engineInformation[i * 2 + 1] & 0x3F;
                ModuleEngine engine = this.getCart().getEngines().get(i);
                float[] rgb = engine.getGuiBarColor();
                GlStateManager.func_179131_c((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)1.0f);
                this.drawImage(7, i * 15 + 2, 66, 0, upperBarLength, 5);
                this.drawImage(7, i * 15 + 2 + 6, 66, 6, lowerBarLength, 5);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.drawImage(5, i * 15, 66 + engine.getPriority() * 7, 11, 7, 15);
            }
        }
        int enginesEndAt = this.getCart().getEngines().size() * 15;
        this.drawImage(5, enginesEndAt, 0, 15, 32, 32);
        if (minecraft.field_71474_y.field_74351_w.func_151470_d()) {
            this.drawImage(15, enginesEndAt + 5, 42, 20, 12, 6);
        } else if (minecraft.field_71474_y.field_74370_x.func_151470_d()) {
            this.drawImage(7, enginesEndAt + 13, 34, 28, 6, 12);
        } else if (minecraft.field_71474_y.field_74366_z.func_151470_d()) {
            this.drawImage(29, enginesEndAt + 13, 56, 28, 6, 12);
        }
        int speedGraphicHeight = this.getSpeedSetting() * 2;
        this.drawImage(14, enginesEndAt + 13 + 12 - speedGraphicHeight, 41, 40 - speedGraphicHeight, 14, speedGraphicHeight);
        this.drawImage(0, 0, 0, 67, 5, 130);
        this.drawImage(1, 1 + (256 - this.getCart().y()) / 2, 5, 67, 5, 1);
        this.drawImage(5, enginesEndAt + 32, 0, 47, 32, 20);
        this.drawImage(5, enginesEndAt + 52, 0, 47, 32, 20);
        this.drawImage(5, enginesEndAt + 72, 0, 47, 32, 20);
        minecraft.field_71466_p.func_78276_b(Localization.MODULES.ATTACHMENTS.ODO.translate(new String[0]), 7, enginesEndAt + 52 + 2, 0x404040);
        minecraft.field_71466_p.func_78276_b(this.distToString(this.odo), 7, enginesEndAt + 52 + 11, 0x404040);
        minecraft.field_71466_p.func_78276_b(Localization.MODULES.ATTACHMENTS.TRIP.translate(new String[0]), 7, enginesEndAt + 52 + 22, 0x404040);
        minecraft.field_71466_p.func_78276_b(this.distToString(this.trip), 7, enginesEndAt + 52 + 31, 0x404040);
        this.drawItem(new ItemStack(Items.field_151113_aN, 1), 5, enginesEndAt + 32 + 3);
        this.drawItem(new ItemStack(Items.field_151111_aL, 1), 21, enginesEndAt + 32 + 3);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawItem(ItemStack icon, int targetX, int targetY) {
        RenderHelper.func_74520_c();
        RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();
        itemRenderer.func_180450_b(icon, targetX, targetY);
    }

    private String distToString(double dist) {
        int i = 0;
        while (dist >= 1000.0) {
            dist /= 1000.0;
            ++i;
        }
        int val = dist >= 100.0 ? 1 : (dist >= 10.0 ? 10 : 100);
        double d = Math.round(dist * (double)val) / (long)val;
        String s = d == (double)((int)d) ? String.valueOf((int)d) : String.valueOf(d);
        while (s.length() < (s.indexOf(46) != -1 ? 4 : 3)) {
            if (s.indexOf(46) != -1) {
                s = s + "0";
                continue;
            }
            s = s + ".0";
        }
        s = s + Localization.MODULES.ATTACHMENTS.DISTANCES.translate(String.valueOf(i));
        return s;
    }

    @Override
    public ModuleBase.RAILDIRECTION getSpecialRailDirection(BlockPos pos) {
        if (this.isForwardKeyDown()) {
            return ModuleBase.RAILDIRECTION.FORWARD;
        }
        if (this.isLeftKeyDown()) {
            return ModuleBase.RAILDIRECTION.LEFT;
        }
        if (this.isRightKeyDown()) {
            return ModuleBase.RAILDIRECTION.RIGHT;
        }
        return ModuleBase.RAILDIRECTION.DEFAULT;
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            this.engineInformation = data;
        } else if (id == 1) {
            if (this.getCart().getCartRider() != null && this.getCart().getCartRider() instanceof EntityPlayer && this.getCart().getCartRider() == player) {
                this.keyinformation = data[0];
                this.getCart().resetRailDirection();
            }
        } else if (id == 2) {
            int intOdo = 0;
            int intTrip = 0;
            for (int i = 0; i < 4; ++i) {
                int temp = data[i];
                if (temp < 0) {
                    temp += 256;
                }
                intOdo |= temp << i * 8;
                temp = data[i + 4];
                if (temp < 0) {
                    temp += 256;
                }
                intTrip |= temp << i * 8;
            }
            this.odo = intOdo;
            this.trip = intTrip;
        } else if (id == 3) {
            this.trip = 0.0;
            this.tripPacketTimer = 0;
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.getCart().field_70170_p.field_72995_K && this.getCart().getCartRider() != null && this.getCart().getCartRider() instanceof EntityPlayer) {
            if (this.enginePacketTimer == 0) {
                this.sendEnginePacket((EntityPlayer)this.getCart().getCartRider());
                this.enginePacketTimer = 15;
            } else {
                --this.enginePacketTimer;
            }
            if (this.tripPacketTimer == 0) {
                this.sendTripPacket((EntityPlayer)this.getCart().getCartRider());
                this.tripPacketTimer = 500;
            } else {
                --this.tripPacketTimer;
            }
        } else {
            this.enginePacketTimer = 0;
            this.tripPacketTimer = 0;
        }
        if (this.getCart().field_70170_p.field_72995_K) {
            this.encodeKeys();
        }
        if (!this.lastBackKey && this.isBackKeyDown()) {
            this.turnback();
        }
        this.lastBackKey = this.isBackKeyDown();
        if (!this.getCart().field_70170_p.field_72995_K) {
            if (this.speedChangeCooldown == 0) {
                if (!this.isJumpKeyDown() || !this.isControlKeyDown()) {
                    if (this.isJumpKeyDown()) {
                        this.setSpeedSetting(this.getSpeedSetting() + 1);
                        this.speedChangeCooldown = 8;
                    } else if (this.isControlKeyDown()) {
                        this.setSpeedSetting(this.getSpeedSetting() - 1);
                        this.speedChangeCooldown = 8;
                    } else {
                        this.speedChangeCooldown = 0;
                    }
                }
            } else {
                --this.speedChangeCooldown;
            }
            if (this.isForwardKeyDown() && this.isLeftKeyDown() && this.isRightKeyDown() && this.getCart().getCartRider() != null && this.getCart().getCartRider() instanceof EntityPlayer) {
                this.getCart().getCartRider().func_184220_m((Entity)this.getCart());
                this.keyinformation = 0;
            }
        }
        double x = this.getCart().field_70165_t - this.lastPosX;
        double y = this.getCart().field_70163_u - this.lastPosY;
        double z = this.getCart().field_70161_v - this.lastPosZ;
        this.lastPosX = this.getCart().field_70165_t;
        this.lastPosY = this.getCart().field_70163_u;
        this.lastPosZ = this.getCart().field_70161_v;
        double dist = Math.sqrt(x * x + y * y + z * z);
        if (!this.first) {
            this.odo += dist;
            this.trip += dist;
        } else {
            this.first = false;
        }
    }

    @Override
    public double getPushFactor() {
        switch (this.getSpeedSetting()) {
            case 1: {
                return 0.01;
            }
            case 2: {
                return 0.03;
            }
            case 3: {
                return 0.05;
            }
            case 4: {
                return 0.07;
            }
            case 5: {
                return 0.09;
            }
            case 6: {
                return 0.11;
            }
        }
        return super.getPushFactor();
    }

    private void encodeKeys() {
        if (this.getCart().getCartRider() != null && this.getCart().getCartRider() instanceof EntityPlayer && this.getCart().getCartRider() == this.getClientPlayer()) {
            Minecraft minecraft = Minecraft.func_71410_x();
            byte oldVal = this.keyinformation;
            this.keyinformation = 0;
            this.keyinformation = (byte)(this.keyinformation | (byte)((minecraft.field_71474_y.field_74351_w.func_151470_d() ? 1 : 0) << 0));
            this.keyinformation = (byte)(this.keyinformation | (byte)((minecraft.field_71474_y.field_74370_x.func_151470_d() ? 1 : 0) << 1));
            this.keyinformation = (byte)(this.keyinformation | (byte)((minecraft.field_71474_y.field_74366_z.func_151470_d() ? 1 : 0) << 2));
            this.keyinformation = (byte)(this.keyinformation | (byte)((minecraft.field_71474_y.field_74368_y.func_151470_d() ? 1 : 0) << 3));
            this.keyinformation = (byte)(this.keyinformation | (byte)((minecraft.field_71474_y.field_74314_A.func_151470_d() ? 1 : 0) << 4));
            this.keyinformation = (byte)(this.keyinformation | (byte)((minecraft.field_71474_y.field_151444_V.func_151470_d() ? 1 : 0) << 5));
            if (oldVal != this.keyinformation) {
                PacketStevesCarts.sendPacket(this.getCart(), 1 + this.getPacketStart(), new byte[]{this.keyinformation});
            }
        }
    }

    private boolean isForwardKeyDown() {
        return (this.keyinformation & 1) != 0;
    }

    private boolean isLeftKeyDown() {
        return (this.keyinformation & 2) != 0;
    }

    private boolean isRightKeyDown() {
        return (this.keyinformation & 4) != 0;
    }

    private boolean isBackKeyDown() {
        return (this.keyinformation & 8) != 0;
    }

    private boolean isJumpKeyDown() {
        return (this.keyinformation & 0x10) != 0;
    }

    private boolean isControlKeyDown() {
        return (this.keyinformation & 0x20) != 0;
    }

    private void sendTripPacket(EntityPlayer player) {
        byte[] data = new byte[8];
        int intOdo = (int)this.odo;
        int intTrip = (int)this.trip;
        for (int i = 0; i < 4; ++i) {
            data[i] = (byte)((intOdo & 255 << i * 8) >> i * 8);
            data[i + 4] = (byte)((intTrip & 255 << i * 8) >> i * 8);
        }
        this.sendPacket(2, data, player);
    }

    private void sendEnginePacket(EntityPlayer player) {
        int engineCount = this.getCart().getEngines().size();
        byte[] data = new byte[engineCount * 2];
        for (int i = 0; i < this.getCart().getEngines().size(); ++i) {
            ModuleEngine engine = this.getCart().getEngines().get(i);
            int totalfuel = engine.getTotalFuel();
            int fuelInTopBar = 20000;
            int maxBarLength = 62;
            float percentage = totalfuel % 20000 / 20000;
            int upperBarLength = (int)(62.0f * percentage);
            int lowerBarLength = totalfuel / 20000;
            if (lowerBarLength > 62) {
                lowerBarLength = 62;
            }
            data[i * 2] = (byte)(upperBarLength & 0x3F);
            data[i * 2 + 1] = (byte)(lowerBarLength & 0x3F);
        }
        this.sendPacket(0, data, player);
    }

    @Override
    public int numberOfPackets() {
        return 4;
    }

    private void setSpeedSetting(int val) {
        if (val < 0 || val > 6) {
            return;
        }
        this.updateDw(this.SPEED, val);
    }

    private int getSpeedSetting() {
        if (this.isPlaceholder()) {
            return 1;
        }
        return this.getDw(this.SPEED);
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void initDw() {
        this.SPEED = this.createDw(DataSerializers.field_187192_b);
        this.registerDw(this.SPEED, 0);
    }

    @Override
    public boolean stopEngines() {
        return this.getSpeedSetting() == 0;
    }

    @Override
    public int getConsumption(boolean isMoving) {
        if (!isMoving) {
            return super.getConsumption(isMoving);
        }
        switch (this.getSpeedSetting()) {
            case 4: {
                return 1;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 5;
            }
        }
        return super.getConsumption(isMoving);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/advlever.png");
        if (this.inRect(x, y, this.buttonRect)) {
            this.drawImage(gui, this.buttonRect, 0, this.buttonRect[3]);
        } else {
            this.drawImage(gui, this.buttonRect, 0, 0);
        }
    }

    @Override
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(gui, Localization.MODULES.ATTACHMENTS.CONTROL_RESET.translate(new String[0]), x, y, this.buttonRect);
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && this.inRect(x, y, this.buttonRect)) {
            this.sendPacket(3);
        }
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, Localization.MODULES.ATTACHMENTS.CONTROL_SYSTEM.translate(new String[0]), 8, 6, 0x404040);
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        tagCompound.func_74774_a(this.generateNBTName("Speed", id), (byte)this.getSpeedSetting());
        tagCompound.func_74780_a(this.generateNBTName("ODO", id), this.odo);
        tagCompound.func_74780_a(this.generateNBTName("TRIP", id), this.trip);
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.setSpeedSetting(tagCompound.func_74771_c(this.generateNBTName("Speed", id)));
        this.odo = tagCompound.func_74769_h(this.generateNBTName("ODO", id));
        this.trip = tagCompound.func_74769_h(this.generateNBTName("TRIP", id));
    }

    public float getWheelAngle() {
        if (!this.isForwardKeyDown()) {
            if (this.isLeftKeyDown()) {
                return 0.3926991f;
            }
            if (this.isRightKeyDown()) {
                return -0.3926991f;
            }
        }
        return 0.0f;
    }

    @Override
    public float getLeverState() {
        if (this.isPlaceholder()) {
            return 0.0f;
        }
        return (float)this.getSpeedSetting() / 6.0f;
    }

    @Override
    public void postUpdate() {
        if (this.getCart().field_70170_p.field_72995_K && this.getCart().getCartRider() != null && this.getCart().getCartRider() instanceof EntityPlayer && this.getCart().getCartRider() == this.getClientPlayer()) {
            KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_151444_V.func_151463_i(), (boolean)false);
            KeyBinding.func_74510_a((int)Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151463_i(), (boolean)false);
        }
    }
}

