/*
 * Decompiled with CFR 0.152.
 */
package com.vladmarica.betterpingdisplay.client;

import com.google.common.collect.Ordering;
import com.mojang.authlib.GameProfile;
import com.vladmarica.betterpingdisplay.BetterPingDisplayConfig;
import com.vladmarica.betterpingdisplay.BetterPingDisplayMod;
import com.vladmarica.betterpingdisplay.client.PlayerComparator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiPlayerTabOverlay;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderPingHandler {
    private static final Ordering<NetworkPlayerInfo> ENTRY_ORDERING = Ordering.from((Comparator)new PlayerComparator());
    private static final int DEFAULT_PING_TEXT_COLOR = 0xA0A0A0;
    private static final String DEFAULT_PING_TEXT_FORMAT = "%dms";
    private static final int PING_TEXT_RENDER_OFFSET = -13;
    private static final int PLAYER_SLOT_EXTRA_WIDTH = 45;
    private static final int PLAYER_ICON_WIDTH = 9;
    private int pingTextColor;
    private String pingTextFormat;

    public RenderPingHandler() {
        if (BetterPingDisplayConfig.textColor.startsWith("#")) {
            try {
                this.pingTextColor = Integer.parseInt(BetterPingDisplayConfig.textColor.substring(1), 16);
                BetterPingDisplayMod.logger().error("Config option 'pingTextColor' is invalid - it must be a hex color code");
            }
            catch (NumberFormatException ex) {
                this.pingTextColor = 0xA0A0A0;
            }
        } else {
            this.pingTextColor = 0xA0A0A0;
        }
        if (BetterPingDisplayConfig.textFormatString.contains("%d")) {
            this.pingTextFormat = BetterPingDisplayConfig.textFormatString;
            BetterPingDisplayMod.logger().error("Config option 'textFormatString' is invalid - it needs to contain %d");
        } else {
            this.pingTextFormat = DEFAULT_PING_TEXT_FORMAT;
        }
    }

    @SubscribeEvent
    public void onRenderGuiPre(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.PLAYER_LIST) {
            event.setCanceled(true);
            this.renderPlayerList(Minecraft.func_71410_x());
        }
    }

    private void renderPlayerList(Minecraft mc) {
        boolean displayPlayerIcons;
        int playerCount;
        GuiPlayerTabOverlay playerListGui = mc.field_71456_v.func_175181_h();
        int width = new ScaledResolution(mc).func_78326_a();
        Scoreboard scoreboard = mc.field_71441_e.func_96441_U();
        ScoreObjective objective = scoreboard.func_96539_a(0);
        NetHandlerPlayClient handler = mc.field_71439_g.field_71174_a;
        List playerList = ENTRY_ORDERING.sortedCopy((Iterable)handler.func_175106_d());
        int i = 0;
        int j = 0;
        for (NetworkPlayerInfo player : playerList) {
            int k = mc.field_71466_p.func_78256_a(playerListGui.func_175243_a(player));
            i = Math.max(i, k);
            if (objective == null || objective.func_178766_e() == IScoreCriteria.EnumRenderType.HEARTS) continue;
            k = mc.field_71466_p.func_78256_a(" " + scoreboard.func_96529_a(player.func_178845_a().getName(), objective).func_96652_c());
            j = Math.max(j, k);
        }
        playerList = playerList.subList(0, Math.min(playerList.size(), 80));
        int i4 = playerCount = playerList.size();
        int j4 = 1;
        while (i4 > 20) {
            i4 = (playerCount + ++j4 - 1) / j4;
        }
        boolean bl = displayPlayerIcons = mc.func_71387_A() || mc.func_147114_u().func_147298_b().func_179292_f();
        int l = objective != null ? (objective.func_178766_e() == IScoreCriteria.EnumRenderType.HEARTS ? 90 : j) : 0;
        int i1 = Math.min(j4 * ((displayPlayerIcons ? 9 : 0) + i + l + 13 + 45), width - 50) / j4;
        int j1 = width / 2 - (i1 * j4 + (j4 - 1) * 5) / 2;
        int k1 = 10;
        int l1 = i1 * j4 + (j4 - 1) * 5;
        List list1 = null;
        if (playerListGui.field_175256_i != null) {
            list1 = mc.field_71466_p.func_78271_c(playerListGui.field_175256_i.func_150254_d(), width - 50);
            for (Iterator s : list1) {
                l1 = Math.max(l1, mc.field_71466_p.func_78256_a((String)((Object)s)));
            }
        }
        List list2 = null;
        if (playerListGui.field_175255_h != null) {
            list2 = mc.field_71466_p.func_78271_c(playerListGui.field_175255_h.func_150254_d(), width - 50);
            for (String s1 : list2) {
                l1 = Math.max(l1, mc.field_71466_p.func_78256_a(s1));
            }
        }
        if (list1 != null) {
            GuiPlayerTabOverlay.func_73734_a((int)(width / 2 - l1 / 2 - 1), (int)(k1 - 1), (int)(width / 2 + l1 / 2 + 1), (int)(k1 + list1.size() * mc.field_71466_p.field_78288_b), (int)Integer.MIN_VALUE);
            for (String s2 : list1) {
                int i2 = mc.field_71466_p.func_78256_a(s2);
                mc.field_71466_p.func_175063_a(s2, (float)(width / 2 - i2 / 2), (float)k1, -1);
                k1 += mc.field_71466_p.field_78288_b;
            }
            ++k1;
        }
        GuiPlayerTabOverlay.func_73734_a((int)(width / 2 - l1 / 2 - 1), (int)(k1 - 1), (int)(width / 2 + l1 / 2 + 1), (int)(k1 + i4 * 9), (int)Integer.MIN_VALUE);
        for (int playerIndex = 0; playerIndex < playerCount; ++playerIndex) {
            int k5;
            int l5;
            int l4 = playerIndex / i4;
            int i5 = playerIndex % i4;
            int j2 = j1 + l4 * i1 + l4 * 5;
            int k2 = k1 + i5 * 9;
            GuiPlayerTabOverlay.func_73734_a((int)j2, (int)k2, (int)(j2 + i1), (int)(k2 + 8), (int)0x20FFFFFF);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            if (playerIndex >= playerList.size()) continue;
            NetworkPlayerInfo player = (NetworkPlayerInfo)playerList.get(playerIndex);
            GameProfile gameprofile = player.func_178845_a();
            if (displayPlayerIcons) {
                EntityPlayer entityplayer = mc.field_71441_e.func_152378_a(gameprofile.getId());
                mc.func_110434_K().func_110577_a(player.func_178837_g());
                Gui.func_152125_a((int)j2, (int)k2, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8, (float)64.0f, (float)64.0f);
                if (entityplayer != null && entityplayer.func_175148_a(EnumPlayerModelParts.HAT)) {
                    Gui.func_152125_a((int)j2, (int)k2, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8, (float)64.0f, (float)64.0f);
                }
                j2 += 9;
            }
            String s4 = playerListGui.func_175243_a(player);
            if (player.func_178848_b() == GameType.SPECTATOR) {
                mc.field_71466_p.func_175063_a(TextFormatting.ITALIC + s4, (float)j2, (float)k2, -1862270977);
            } else {
                mc.field_71466_p.func_175063_a(s4, (float)j2, (float)k2, -1);
            }
            if (objective != null && player.func_178848_b() != GameType.SPECTATOR && (l5 = (k5 = j2 + i + 1) + l) - k5 > 5) {
                playerListGui.func_175247_a(objective, k2, gameprofile.getName(), k5, l5, player);
            }
            String pingString = String.format(this.pingTextFormat, player.func_178853_c());
            int pingStringWidth = mc.field_71466_p.func_78256_a(pingString);
            mc.field_71466_p.func_175063_a(pingString, (float)i1 + (float)j2 - (float)pingStringWidth + -13.0f - (float)(displayPlayerIcons ? 9 : 0), (float)k2, this.pingTextColor);
            playerListGui.func_175245_a(i1, j2 - (displayPlayerIcons ? 9 : 0), k2, player);
        }
        if (list2 != null) {
            k1 = k1 + i4 * 9 + 1;
            GuiPlayerTabOverlay.func_73734_a((int)(width / 2 - l1 / 2 - 1), (int)(k1 - 1), (int)(width / 2 + l1 / 2 + 1), (int)(k1 + list2.size() * mc.field_71466_p.field_78288_b), (int)Integer.MIN_VALUE);
            for (String s3 : list2) {
                int j5 = mc.field_71466_p.func_78256_a(s3);
                mc.field_71466_p.func_175063_a(s3, (float)(width / 2 - j5 / 2), (float)k1, -1);
                k1 += mc.field_71466_p.field_78288_b;
            }
        }
    }
}

