/*
 * Decompiled with CFR 0.152.
 */
package mod.acgaming.universaltweaks.mods.forestry.mixin;

import forestry.core.blocks.BlockBase;
import forestry.core.blocks.IBlockType;
import forestry.core.blocks.IMachinePropertiesTesr;
import java.util.Random;
import mod.acgaming.universaltweaks.config.UTConfigMods;
import mod.acgaming.universaltweaks.util.particle.UTParticleSituationEnum;
import mod.acgaming.universaltweaks.util.particle.UTParticleSpawnerMessage;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BlockBase.class})
public abstract class UTBaseBlockMixin<P extends Enum<P> & IStringSerializable>
extends Block {
    @Shadow(remap=false)
    @Final
    public P blockType;

    public UTBaseBlockMixin(Material materialIn) {
        super(materialIn);
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState unused, EntityLivingBase entity, int numberOfParticles) {
        if (!UTConfigMods.FORESTRY.utParticleFixesToggle) {
            return false;
        }
        UTParticleSpawnerMessage.send(world, EnumParticleTypes.BLOCK_DUST, UTParticleSituationEnum.FORESTRY, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 0.0, 0.0, 0.0, 0.15, numberOfParticles, UTBaseBlockMixin.func_176210_f((IBlockState)state));
        return true;
    }

    public boolean addRunningEffects(IBlockState state, World world, BlockPos pos, Entity entity) {
        if (!UTConfigMods.FORESTRY.utParticleFixesToggle) {
            return false;
        }
        if (world.field_72995_K && ((IBlockType)this.blockType).getMachineProperties() instanceof IMachinePropertiesTesr) {
            this.addRunningEffectsOnClient(world, entity, state, (IMachinePropertiesTesr)((IBlockType)this.blockType).getMachineProperties());
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    private void addRunningEffectsOnClient(World world, Entity entity, IBlockState state, IMachinePropertiesTesr tesrProps) {
        Minecraft mc = Minecraft.func_71410_x();
        Random rand = world.field_73012_v;
        ParticleManager effectRenderer = mc.field_71452_i;
        ParticleDigging particle = (ParticleDigging)effectRenderer.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), entity.field_70165_t + ((double)rand.nextFloat() - 0.5) * (double)entity.field_70130_N, entity.func_174813_aQ().field_72338_b + 0.1, entity.field_70161_v + ((double)rand.nextFloat() - 0.5) * (double)entity.field_70130_N, -entity.field_70159_w * 4.0, 1.5, -entity.field_70179_y * 4.0, new int[]{UTBaseBlockMixin.func_176210_f((IBlockState)state)});
        particle.func_187117_a(mc.field_175617_aL.func_174952_b().func_110572_b(tesrProps.getParticleTextureLocation()));
    }
}

