/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.mixin.textures;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.util.ResourceLocation;
import org.embeddedt.vintagefix.VintageFix;
import org.embeddedt.vintagefix.annotation.ClientOnlyMixin;
import org.embeddedt.vintagefix.stitcher.IAsyncTexture;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SimpleTexture.class})
@ClientOnlyMixin
public abstract class MixinSimpleTexture
extends AbstractTexture
implements IAsyncTexture {
    @Shadow
    @Final
    protected ResourceLocation field_110568_b;
    private CompletableFuture<Void> asyncTextureLoad = null;
    private int[][] imageData;
    private int width;
    private int height;
    private boolean blur;
    private boolean clamp;

    @Override
    public void runAsyncLoadPortion(IResourceManager manager, Executor executor) {
        this.asyncTextureLoad = CompletableFuture.runAsync(() -> {
            block17: {
                try (IResource resource = manager.func_110536_a(this.field_110568_b);){
                    BufferedImage bufferedImage = TextureUtil.func_177053_a((InputStream)resource.func_110527_b());
                    this.width = bufferedImage.getWidth();
                    this.height = bufferedImage.getHeight();
                    int[][] data = new int[1][this.width * this.height];
                    bufferedImage.getRGB(0, 0, this.width, this.height, data[0], 0, this.width);
                    this.imageData = data;
                    this.blur = false;
                    this.clamp = false;
                    if (!resource.func_110528_c()) break block17;
                    try {
                        TextureMetadataSection texturemetadatasection = (TextureMetadataSection)resource.func_110526_a("texture");
                        if (texturemetadatasection != null) {
                            this.blur = texturemetadatasection.func_110479_a();
                            this.clamp = texturemetadatasection.func_110480_b();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        // empty catch block
                    }
                }
                catch (IOException | RuntimeException e) {
                    this.imageData = null;
                    VintageFix.LOGGER.error("Exception reading texture", (Throwable)e);
                }
            }
        }, executor);
    }

    @Inject(method={"loadTexture"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/texture/SimpleTexture;deleteGlTexture()V", shift=At.Shift.AFTER)}, cancellable=true)
    private void loadFast(IResourceManager resourceManager, CallbackInfo ci) {
        if (this.asyncTextureLoad != null) {
            this.asyncTextureLoad.join();
            this.asyncTextureLoad = null;
            if (this.imageData != null) {
                TextureUtil.func_110991_a((int)this.func_110552_b(), (int)this.width, (int)this.height);
                GlStateManager.func_179144_i((int)this.func_110552_b());
                TextureUtil.func_147955_a((int[][])this.imageData, (int)this.width, (int)this.height, (int)0, (int)0, (boolean)this.blur, (boolean)this.clamp);
                ci.cancel();
            }
        }
    }
}

