/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.vintagefix.dynamicresources.helpers;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipError;
import net.minecraft.client.resources.DefaultResourcePack;
import org.embeddedt.vintagefix.VintageFix;
import org.embeddedt.vintagefix.dynamicresources.ResourcePackHelper;
import org.embeddedt.vintagefix.util.Util;

public class DefaultPackAdapter
implements ResourcePackHelper.Adapter<DefaultResourcePack> {
    private static synchronized Iterator<String> walkFileSystems(Class<?> clz, FSConsumer consumer) throws IOException {
        FileSystem mainFs;
        block14: {
            try {
                URI uri = clz.getResource("/assets/.mcassetsroot").toURI();
                if ("jar".equals(uri.getScheme())) {
                    try {
                        mainFs = FileSystems.getFileSystem(uri);
                    }
                    catch (FileSystemNotFoundException var11) {
                        mainFs = FileSystems.newFileSystem(uri, Collections.emptyMap());
                    }
                    break block14;
                }
                throw new IOException("Wrong URI scheme: " + uri.getScheme());
            }
            catch (URISyntaxException e) {
                throw new IOException("Couldn't list vanilla resources", e);
            }
        }
        HashSet<String> set = new HashSet<String>(consumer.accept(mainFs));
        mainFs.close();
        if (clz.getClassLoader() instanceof URLClassLoader) {
            URLClassLoader cl = (URLClassLoader)clz.getClassLoader();
            for (URL url : cl.getURLs()) {
                if (Objects.equals(url.getProtocol(), "asmgen")) continue;
                Object newList = ImmutableList.of();
                URI uri = null;
                try {
                    FileSystem fs;
                    uri = new URI("jar", URLDecoder.decode(url.toURI().toString(), "UTF-8"), null);
                    boolean needClose = false;
                    try {
                        fs = FileSystems.getFileSystem(uri);
                    }
                    catch (FileSystemNotFoundException e) {
                        fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
                        needClose = true;
                    }
                    try {
                        newList = consumer.accept(fs);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (newList.size() > 0) {
                        set.addAll((Collection<String>)newList);
                    }
                    if (!needClose) continue;
                    fs.close();
                }
                catch (IOException | RuntimeException | URISyntaxException | ZipError e) {
                    VintageFix.LOGGER.error("Error accessing resource pack on classpath{}", uri != null ? " (with URI " + uri + ")" : null, (Object)e);
                }
            }
        }
        return set.iterator();
    }

    @Override
    public Iterator<String> getAllPaths(DefaultResourcePack pack, Predicate<String> filter) throws IOException {
        return DefaultPackAdapter.walkFileSystems(DefaultResourcePack.class, fs -> {
            Path basePath = fs.getPath("/assets", new String[0]);
            try (Stream<Path> stream = Files.walk(basePath, new FileVisitOption[0]);){
                List list = stream.map(basePath::relativize).map(p -> "/assets/" + Util.normalizePathToString(p)).filter(filter).collect(Collectors.toList());
                return list;
            }
        });
    }

    @FunctionalInterface
    private static interface FSConsumer {
        public List<String> accept(FileSystem var1) throws IOException;
    }
}

